/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.basic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.security.ConversationState;
import org.xcmis.spi.CmisRuntimeException;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.ContentStream;
import org.xcmis.spi.DocumentData;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.NameConstraintViolationException;
import org.xcmis.spi.NotSupportedException;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.PermissionService;
import org.xcmis.spi.PolicyData;
import org.xcmis.spi.RelationshipData;
import org.xcmis.spi.Storage;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.TypeManager;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.UpdateConflictException;
import org.xcmis.spi.VersioningException;
import org.xcmis.spi.model.AccessControlEntry;
import org.xcmis.spi.model.AllowableActions;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.ChangeEvent;
import org.xcmis.spi.model.Property;
import org.xcmis.spi.model.Rendition;
import org.xcmis.spi.model.RepositoryInfo;
import org.xcmis.spi.model.TypeDefinition;
import org.xcmis.spi.model.VersioningState;
import org.xcmis.spi.query.Query;
import org.xcmis.spi.query.Result;
import org.xcmis.spi.utils.CmisUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicStorage
implements Storage {
    protected RepositoryInfo repositoryInfo;
    protected TypeManager typeManager;
    protected PermissionService permissionService;

    public BasicStorage(RepositoryInfo repositoryInfo, TypeManager typeManager, PermissionService permissionService) {
        this.repositoryInfo = repositoryInfo;
        this.typeManager = typeManager;
        this.permissionService = permissionService;
    }

    @Override
    public RepositoryInfo getRepositoryInfo() {
        return this.repositoryInfo;
    }

    @Override
    public AllowableActions calculateAllowableActions(ObjectData object) {
        ConversationState state = ConversationState.getCurrent();
        AllowableActions actions = this.permissionService.calculateAllowableActions(object, state != null ? state.getIdentity() : null, this.getRepositoryInfo());
        return actions;
    }

    @Override
    public String addType(TypeDefinition type) throws ConstraintException, StorageException, CmisRuntimeException {
        return this.typeManager.addType(type);
    }

    @Override
    public void removeType(String typeId) throws TypeNotFoundException, ConstraintException, StorageException, CmisRuntimeException {
        this.typeManager.removeType(typeId);
    }

    @Override
    public ItemsIterator<TypeDefinition> getTypeChildren(String typeId, boolean includePropertyDefinitions) throws TypeNotFoundException, CmisRuntimeException {
        return this.typeManager.getTypeChildren(typeId, includePropertyDefinitions);
    }

    @Override
    public TypeDefinition getTypeDefinition(String typeId, boolean includePropertyDefinition) throws TypeNotFoundException, CmisRuntimeException {
        return this.typeManager.getTypeDefinition(typeId, includePropertyDefinition);
    }

    @Override
    public DocumentData createDocument(FolderData parent, TypeDefinition typeDefinition, Map<String, Property<?>> properties, ContentStream content, List<AccessControlEntry> acl, Collection<PolicyData> policies, VersioningState versioningState) throws ConstraintException, NameConstraintViolationException, IOException, StorageException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PolicyData createPolicy(FolderData parent, TypeDefinition typeDefinition, Map<String, Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws ConstraintException, NameConstraintViolationException, StorageException {
        throw new NotSupportedException();
    }

    @Override
    public RelationshipData createRelationship(ObjectData source, ObjectData target, TypeDefinition typeDefinition, Map<String, Property<?>> properties, List<AccessControlEntry> acl, Collection<PolicyData> policies) throws NameConstraintViolationException, StorageException {
        throw new NotSupportedException();
    }

    @Override
    public Collection<DocumentData> getAllVersions(String versionSeriesId) throws ObjectNotFoundException {
        ObjectData data = this.getObjectById(versionSeriesId);
        if (data.getBaseType() == BaseType.DOCUMENT) {
            ArrayList<DocumentData> l = new ArrayList<DocumentData>(1);
            l.add((DocumentData)data);
            return l;
        }
        return Collections.emptySet();
    }

    @Override
    public ItemsIterator<ChangeEvent> getChangeLog(String changeLogToken) throws ConstraintException {
        throw new NotSupportedException();
    }

    public ItemsIterator<DocumentData> getCheckedOutDocuments(ObjectData folder, String orderBy) {
        throw new NotSupportedException();
    }

    @Override
    public String getId() {
        return this.repositoryInfo.getRepositoryId();
    }

    @Override
    public ItemsIterator<Rendition> getRenditions(ObjectData object) {
        return CmisUtils.emptyItemsIterator();
    }

    @Override
    public ObjectData moveObject(ObjectData object, FolderData target, FolderData source) throws UpdateConflictException, VersioningException, NameConstraintViolationException, StorageException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ItemsIterator<Result> query(Query query) throws InvalidArgumentException {
        throw new NotSupportedException();
    }

    @Override
    public void unfileObject(ObjectData object) {
        throw new NotSupportedException();
    }

    @Override
    public Iterator<String> getUnfiledObjectsId() throws StorageException {
        throw new UnsupportedOperationException();
    }
}

