/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/profile/UIProfileUserSearch.gtmpl", events={@EventConfig(listeners={SearchActionListener.class})})
public class UIProfileUserSearch
extends UIForm {
    public static final String USER_CONTACT = "name";
    public static final String SKILLS = "skills";
    public static final String POSITION = "position";
    public static final String GENDER = "gender";
    public static final String SEARCH = "Search";
    public static final String EXPERIENCE = "experiences";
    public static final String GENDER_DEFAULT = "Gender";
    public static final String MALE = "male";
    public static final String FEMALE = "female";
    public static final String REG_FOR_SPLIT = "[^_A-Za-z0-9-.\\s[\\n]]";
    static final String RIGHT_INPUT_PATTERN = "^[\\p{L}][\\p{L}._\\- \\d]+$";
    public static final String POSITION_REGEX_EXPRESSION = "^\\p{L}[\\p{L}\\d._,\\s]+\\p{L}$";
    static final String PREFIX_ADDED_FOR_CHECK = "PrefixAddedForCheck";
    IdentityManager im = null;
    RelationshipManager rm = null;
    Identity currIdentity = null;
    private List<Identity> identityList = null;
    String selectedChar = null;
    ProfileFilter profileFilter = null;
    List<String> allUserContactName = null;

    public void setIdentityList(List<Identity> identityList) {
        this.identityList = identityList;
    }

    public List<Identity> getIdentityList() throws Exception {
        return this.identityList;
    }

    public String getSelectedChar() {
        return this.selectedChar;
    }

    public void setSelectedChar(String selectedChar) {
        this.selectedChar = selectedChar;
    }

    public ProfileFilter getProfileFilter() {
        return this.profileFilter;
    }

    public void setProfileFilter(ProfileFilter profileFilter) {
        this.profileFilter = profileFilter;
    }

    public List<String> getAllContactName() throws Exception {
        return this.allUserContactName;
    }

    public void setAllUserContactName(List<String> allUserContactName) {
        this.allUserContactName = allUserContactName;
    }

    public UIProfileUserSearch() throws Exception {
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        options.add(new SelectItemOption((Object)GENDER_DEFAULT));
        options.add(new SelectItemOption((Object)MALE));
        options.add(new SelectItemOption((Object)FEMALE));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SEARCH, USER_CONTACT, USER_CONTACT));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(POSITION, POSITION, POSITION));
        this.addUIFormInput((UIFormInput)new UIFormStringInput(SKILLS, SKILLS, SKILLS));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(GENDER, GENDER, options));
    }

    public Identity getCurrentIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        return im.getOrCreateIdentity("organization", this.getCurrentUserName());
    }

    public Identity getCurrentViewerIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        Identity identity = null;
        identity = im.getOrCreateIdentity("organization", this.getCurrentViewerUserName());
        if (identity == null) {
            return im.getOrCreateIdentity("organization", this.getCurrentUserName());
        }
        return identity;
    }

    public String getCurrentUserName() {
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    private List<Identity> getIdentitiesBySkills(String skills, List<Identity> identities) {
        ArrayList<Identity> identityLst = new ArrayList<Identity>();
        String prof = null;
        ArrayList experiences = new ArrayList();
        String skill = skills.trim().toLowerCase();
        if (identities.size() == 0) {
            return identityLst;
        }
        for (Identity id : identities) {
            Profile profile = id.getProfile();
            experiences = (ArrayList)profile.getProperty(EXPERIENCE);
            if (experiences == null) continue;
            block1: for (HashMap exp : experiences) {
                String[] items;
                prof = (String)exp.get(SKILLS);
                if (prof == null) continue;
                Pattern p = Pattern.compile(REG_FOR_SPLIT);
                for (String item : items = p.split(prof)) {
                    if (!item.toLowerCase().matches(skill)) continue;
                    identityLst.add(id);
                    continue block1;
                }
            }
        }
        return UIProfileUserSearch.GetUniqueIdentities(identityLst);
    }

    private IdentityManager getIdentityManager() {
        if (this.im == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.im;
    }

    private String getCurrentViewerUserName() {
        String username = URLUtils.getCurrentUser();
        if (username != null) {
            return username;
        }
        PortalRequestContext portalRequest = Util.getPortalRequestContext();
        return portalRequest.getRemoteUser();
    }

    private static Collection<Identity> Union(Collection<Identity> identities1, Collection<Identity> identities2) {
        HashSet<Identity> identities = new HashSet<Identity>(identities1);
        identities.addAll(new HashSet<Identity>(identities2));
        return new ArrayList<Identity>(identities);
    }

    private static ArrayList<Identity> GetUniqueIdentities(Collection<Identity> identities) {
        return (ArrayList)UIProfileUserSearch.Union(identities, identities);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIProfileUserSearch> {
        public void execute(Event<UIProfileUserSearch> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UIProfileUserSearch uiSearch = (UIProfileUserSearch)((Object)event.getSource());
            String charSearch = ctx.getRequestParameter("objectId");
            ArrayList<Identity> identitiesSearchResult = new ArrayList();
            ArrayList<Identity> identities = new ArrayList();
            IdentityManager idm = uiSearch.getIdentityManager();
            ProfileFilter filter = new ProfileFilter();
            uiSearch.invokeSetBindingBean(filter);
            ResourceBundle resApp = ctx.getApplicationResourceBundle();
            String defaultNameVal = resApp.getString(uiSearch.getId() + ".label.Name");
            String defaultPosVal = resApp.getString(uiSearch.getId() + ".label.Position");
            String defaultSkillsVal = resApp.getString(uiSearch.getId() + ".label.Skills");
            String defaultGenderVal = resApp.getString(uiSearch.getId() + ".label.AllGender");
            try {
                uiSearch.setSelectedChar(charSearch);
                if (charSearch != null) {
                    ((UIFormStringInput)uiSearch.getChildById(UIProfileUserSearch.SEARCH)).setValue((Object)defaultNameVal);
                    ((UIFormStringInput)uiSearch.getChildById(UIProfileUserSearch.POSITION)).setValue((Object)defaultPosVal);
                    ((UIFormStringInput)uiSearch.getChildById(UIProfileUserSearch.SKILLS)).setValue((Object)defaultSkillsVal);
                    ((UIFormStringInput)uiSearch.getChildById(UIProfileUserSearch.GENDER)).setValue((Object)defaultGenderVal);
                    filter.setName(charSearch);
                    filter.setPosition("");
                    filter.setGender("");
                    if ("All".equals(charSearch)) {
                        filter.setName("");
                    }
                    identitiesSearchResult = idm.getIdentitiesFilterByAlphaBet("organization", filter);
                    uiSearch.setIdentityList(identitiesSearchResult);
                } else if (!this.isValidInput(filter)) {
                    uiSearch.setIdentityList(new ArrayList<Identity>());
                } else {
                    if (filter.getName() == null || filter.getName().equals(defaultNameVal)) {
                        filter.setName("");
                    }
                    if (filter.getPosition() == null || filter.getPosition().equals(defaultPosVal)) {
                        filter.setPosition("");
                    }
                    if (filter.getSkills() == null || filter.getSkills().equals(defaultSkillsVal)) {
                        filter.setSkills("");
                    }
                    if (filter.getGender().equals(defaultGenderVal)) {
                        filter.setGender("");
                    }
                    String skills = null;
                    identitiesSearchResult = idm.getIdentitiesByProfileFilter("organization", filter);
                    uiSearch.setIdentityList(identitiesSearchResult);
                    skills = filter.getSkills();
                    if (skills.length() > 0) {
                        skills = skills == "" || skills.length() == 0 ? "*" : skills;
                        skills = skills.charAt(0) != '*' ? "*" + skills : skills;
                        skills = skills.charAt(skills.length() - 1) != '*' ? (skills = skills + "*") : skills;
                        skills = skills.indexOf("*") >= 0 ? skills.replace("*", ".*") : skills;
                        skills = skills.indexOf("%") >= 0 ? skills.replace("%", ".*") : skills;
                        Pattern.compile(skills);
                        identities = uiSearch.getIdentitiesBySkills(skills, identitiesSearchResult);
                        uiSearch.setIdentityList(identities);
                    }
                }
            }
            catch (Exception e) {
                uiSearch.setIdentityList(new ArrayList<Identity>());
            }
            Event searchEvent = uiSearch.getParent().createEvent(UIProfileUserSearch.SEARCH, Event.Phase.DECODE, ctx);
            if (searchEvent != null) {
                searchEvent.broadcast();
            }
        }

        private boolean isValidInput(ProfileFilter input) {
            String contactName = input.getName();
            String contactNameForCheck = null;
            if (contactName != null) {
                contactNameForCheck = contactName.trim().replace("*", "");
                contactNameForCheck = contactNameForCheck.replace("%", "");
                contactNameForCheck = UIProfileUserSearch.PREFIX_ADDED_FOR_CHECK + contactNameForCheck;
                if (!contactNameForCheck.matches(UIProfileUserSearch.RIGHT_INPUT_PATTERN)) {
                    return false;
                }
            }
            String position = input.getPosition();
            String positionForCheck = null;
            if (position != null) {
                positionForCheck = position.trim().replace("*", "");
                positionForCheck = positionForCheck.replace("%", "");
                positionForCheck = UIProfileUserSearch.PREFIX_ADDED_FOR_CHECK + positionForCheck;
                if (!positionForCheck.matches(UIProfileUserSearch.POSITION_REGEX_EXPRESSION)) {
                    return false;
                }
            }
            return true;
        }
    }
}

