/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.usermodel;

import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.hssf.record.EmbeddedObjectRefSubRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.HexDump;

public class HSSFObjectData {
    private ObjRecord record;
    private POIFSFileSystem poifs;

    public HSSFObjectData(ObjRecord record, POIFSFileSystem poifs) {
        this.record = record;
        this.poifs = poifs;
    }

    public DirectoryEntry getDirectory() throws IOException {
        Iterator subRecordIter = this.record.getSubRecords().iterator();
        while (subRecordIter.hasNext()) {
            Object subRecord = subRecordIter.next();
            if (!(subRecord instanceof EmbeddedObjectRefSubRecord)) continue;
            int streamId = ((EmbeddedObjectRefSubRecord)subRecord).getStreamId();
            String streamName = "MBD" + HexDump.toHex(streamId);
            Entry entry = this.poifs.getRoot().getEntry(streamName);
            if (entry instanceof DirectoryEntry) {
                return (DirectoryEntry)entry;
            }
            throw new IOException("Stream " + streamName + " was not an OLE2 directory");
        }
        throw new IllegalStateException("Object data does not contain a reference to an embedded object OLE2 directory");
    }
}

