/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.ldap;

import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.services.ldap.LDAPService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.ldap.BaseDAO;
import org.exoplatform.services.organization.ldap.LDAPAttributeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LdapUserListAccess
implements ListAccess<User> {
    protected String searchBase;
    protected String filter;
    protected LDAPAttributeMapping ldapAttrMapping;
    protected LDAPService ldapService;

    public LdapUserListAccess(LDAPAttributeMapping ldapAttrMapping, LDAPService ldapService, String searchBase, String filter) {
        this.ldapService = ldapService;
        this.ldapAttrMapping = ldapAttrMapping;
        this.searchBase = searchBase;
        this.filter = filter;
    }

    public int getSize() throws Exception {
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    int n = this.getSize(ctx);
                    return n;
                }
                catch (NamingException e) {
                    if (!BaseDAO.isConnectionError(e) || err >= BaseDAO.getMaxConnectionError()) {
                        throw e;
                    }
                    ctx = this.ldapService.getLdapContext(true);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    public User[] load(int index, int length) throws Exception, IllegalArgumentException {
        LdapContext ctx = this.ldapService.getLdapContext();
        try {
            int err = 0;
            while (true) {
                try {
                    User[] userArray = this.load(ctx, index, length);
                    return userArray;
                }
                catch (NamingException e) {
                    if (!BaseDAO.isConnectionError(e) || err >= BaseDAO.getMaxConnectionError()) {
                        throw e;
                    }
                    ctx = this.ldapService.getLdapContext(true);
                    ++err;
                    continue;
                }
                break;
            }
        }
        finally {
            this.ldapService.release(ctx);
        }
    }

    protected abstract User[] load(LdapContext var1, int var2, int var3) throws Exception;

    protected abstract int getSize(LdapContext var1) throws Exception;
}

