/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.gandiva.inventory.InventoryElement;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreImple;
import com.arjuna.ats.internal.arjuna.objectstore.StoreList;

public abstract class ObjectStoreSetup
implements InventoryElement {
    private static boolean _alwaysCreate = false;
    private static StoreList _headOfList = null;

    protected abstract ObjectStoreImple create(String var1);

    protected ObjectStoreSetup() {
    }

    protected synchronized ObjectStoreImple createStore(String location) {
        StoreList slptr = null;
        boolean found = false;
        boolean endOfList = false;
        if (location == null) {
            location = "";
        }
        slptr = _headOfList;
        while (slptr != null && !found && !endOfList) {
            if (!_alwaysCreate) {
                String sName = slptr.instance.getStoreName();
                if (sName == null) {
                    sName = "";
                }
                if (sName.compareTo(location) == 0) {
                    found = true;
                    break;
                }
            }
            if (slptr.next != null) {
                slptr = slptr.next;
                continue;
            }
            endOfList = true;
        }
        if (!found) {
            StoreList toAdd = new StoreList();
            toAdd.instance = this.create(location);
            if (_headOfList == null) {
                _headOfList = toAdd;
            } else {
                slptr.next = toAdd;
            }
            slptr = toAdd;
        }
        ++slptr.useCount;
        return slptr.instance;
    }

    private synchronized boolean referenceStore(ObjectStoreImple toRef) {
        StoreList slptr = null;
        boolean found = false;
        boolean endOfList = false;
        slptr = _headOfList;
        while (slptr != null && !found && !endOfList) {
            if (slptr.instance == toRef) {
                found = true;
                continue;
            }
            if (slptr.next != null) {
                slptr = slptr.next;
                continue;
            }
            endOfList = true;
        }
        if (!found) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ObjectStoreSetup_1");
            }
            return false;
        }
        ++slptr.useCount;
        return true;
    }

    private synchronized void destroyStore(String location, ObjectStoreImple toDelete) {
        if (toDelete == null) {
            return;
        }
        StoreList slptr = null;
        StoreList slmarker = null;
        boolean found = false;
        if (location == null) {
            location = "";
        }
        if (_headOfList == null) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ObjectStoreSetup_2");
            }
            return;
        }
        slptr = _headOfList;
        while (slptr != null && !found) {
            if (slptr.instance == toDelete) {
                found = true;
                continue;
            }
            slmarker = slptr;
            slptr = slptr.next;
        }
        if (!found) {
            if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
                tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ObjectStoreSetup_3");
            }
            toDelete = null;
            return;
        }
        --slptr.useCount;
        if (slptr.useCount == 0L) {
            if (slmarker == null) {
                _headOfList = slptr.next;
            } else {
                slmarker.next = slptr.next;
            }
            toDelete = null;
        }
    }
}

