/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tools {
    public static <E> Set<E> set(E ... elements) throws NullPointerException {
        if (elements == null) {
            throw new NullPointerException("No null element array accepted");
        }
        HashSet<E> set = new HashSet<E>();
        if (elements.length > 0) {
            for (E element : elements) {
                set.add(element);
            }
        }
        return set;
    }

    public static Set<String> parseCommaList(String s) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException("No null string list accepted");
        }
        HashSet<String> set = new HashSet<String>();
        for (String v : s.split(",")) {
            if ((v = v.trim()).length() <= 0) continue;
            set.add(v);
        }
        return set;
    }

    public static Properties asProperties(Map<String, String> map) throws NullPointerException {
        if (map == null) {
            throw new NullPointerException("No null map accepted");
        }
        Properties props = new Properties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            props.setProperty(entry.getKey(), entry.getValue());
        }
        return props;
    }

    public static Map<String, String> asMap(Properties props) throws NullPointerException {
        if (props == null) {
            throw new NullPointerException("No null properties accepted");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Object key : props.keySet()) {
            Object value = props.get(key);
            if (!(key instanceof String) || !(value instanceof String)) continue;
            map.put((String)key, (String)value);
        }
        return map;
    }

    public static boolean endsWithIgnoreCase(String s, String end) throws NullPointerException {
        if (s == null) {
            throw new NullPointerException();
        }
        if (end == null) {
            throw new NullPointerException();
        }
        if (s.length() < end.length()) {
            return false;
        }
        String suffix = s.substring(s.length() - end.length());
        return suffix.equalsIgnoreCase(end);
    }
}

