/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.mail.Address;
import javax.mail.internet.InternetAddress;
import org.exoplatform.mail.service.Message;
import org.exoplatform.mail.service.Utils;

public class SpamFilter {
    private String[] senderAddresses = new String[0];

    public String[] getSenders() {
        return this.senderAddresses;
    }

    public void setSenders(String[] arr) {
        this.senderAddresses = arr;
    }

    public void reportSpam(Message msg) throws Exception {
        ArrayList<String> senderList = new ArrayList<String>(Arrays.asList(this.getSenders()));
        HashMap<String, String> senderMap = new HashMap<String, String>();
        for (String sender : senderList) {
            senderMap.put(sender, sender);
        }
        String sender = Utils.getAddresses(msg.getFrom())[0];
        senderMap.put(sender, sender);
        this.setSenders(senderMap.values().toArray(new String[0]));
    }

    public void notSpam(Message msg) throws Exception {
        ArrayList<String> senderList = new ArrayList<String>(Arrays.asList(this.getSenders()));
        String sender = Utils.getAddresses(msg.getFrom())[0];
        senderList.remove(sender);
        this.setSenders(senderList.toArray(new String[0]));
    }

    public boolean checkSpam(javax.mail.Message msg) throws Exception {
        ArrayList<String> senderList = new ArrayList<String>(Arrays.asList(this.getSenders()));
        String sender = Utils.getAddresses(InternetAddress.toString((Address[])msg.getFrom()))[0];
        return senderList.contains(sender);
    }
}

