/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.config;

import java.lang.reflect.Method;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheException;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.ConfigurationComponent;
import org.jboss.cache.config.ConfigurationException;
import org.jboss.cache.config.Dynamic;
import org.jboss.cache.config.EvictionAlgorithmConfig;
import org.jboss.cache.config.EvictionConfig;
import org.jboss.cache.config.EvictionPolicyConfig;
import org.jboss.cache.config.MissingPolicyException;
import org.jboss.cache.config.UnsupportedEvictionImplException;
import org.jboss.cache.eviction.ModernizableConfig;
import org.jboss.cache.util.Util;

public class EvictionRegionConfig
extends ConfigurationComponent {
    private static final long serialVersionUID = -5482474634995601400L;
    public static final String NAME = "name";
    public static final String REGION = "region";
    private Fqn regionFqn;
    @Dynamic
    private Integer eventQueueSize;
    private EvictionAlgorithmConfig evictionAlgorithmConfig;
    @Deprecated
    private EvictionPolicyConfig deprecatedConfig;
    private String evictionActionPolicyClassName;

    public EvictionRegionConfig() {
    }

    @Deprecated
    public EvictionRegionConfig(Fqn regionFqn, EvictionPolicyConfig evictionPolicyConfig) {
        this.regionFqn = regionFqn;
        if (!(evictionPolicyConfig instanceof ModernizableConfig)) {
            throw new ConfigurationException("Unable to convert " + evictionPolicyConfig.getClass().getName() + " to a more modern format, implementing " + EvictionAlgorithmConfig.class.getSimpleName() + ".  Please use " + EvictionAlgorithmConfig.class.getSimpleName() + " which replaces the deprecated " + EvictionPolicyConfig.class.getSimpleName());
        }
        this.evictionAlgorithmConfig = ((ModernizableConfig)((Object)evictionPolicyConfig)).modernizeConfig();
        this.deprecatedConfig = evictionPolicyConfig;
    }

    public EvictionRegionConfig(Fqn regionFqn, EvictionAlgorithmConfig evictionAlgorithmConfig) {
        this.regionFqn = regionFqn;
        this.evictionAlgorithmConfig = evictionAlgorithmConfig;
    }

    public EvictionRegionConfig(Fqn regionFqn, EvictionAlgorithmConfig evictionAlgorithmConfig, int queueSize) {
        this.regionFqn = regionFqn;
        this.evictionAlgorithmConfig = evictionAlgorithmConfig;
        this.eventQueueSize = queueSize;
    }

    public EvictionRegionConfig(Fqn fqn) {
        this.regionFqn = fqn;
    }

    @Deprecated
    public EvictionPolicyConfig getEvictionPolicyConfig() {
        if (this.deprecatedConfig != null) {
            return this.deprecatedConfig;
        }
        throw new CacheException("Not supported.  Please use " + EvictionAlgorithmConfig.class.getSimpleName() + " instead of " + EvictionPolicyConfig.class.getSimpleName());
    }

    public EvictionAlgorithmConfig getEvictionAlgorithmConfig() {
        return this.evictionAlgorithmConfig;
    }

    @Deprecated
    public void setEvictionPolicyConfig(EvictionPolicyConfig evictionPolicyConfig) {
        if (!(evictionPolicyConfig instanceof ModernizableConfig)) {
            throw new UnsupportedEvictionImplException("Unable to convert " + evictionPolicyConfig.getClass().getName() + " to a more modern format, implementing " + EvictionAlgorithmConfig.class.getSimpleName() + ".  Please use " + EvictionAlgorithmConfig.class.getSimpleName() + " which replaces the deprecated " + EvictionPolicyConfig.class.getSimpleName());
        }
        this.deprecatedConfig = evictionPolicyConfig;
        this.setEvictionAlgorithmConfig(((ModernizableConfig)((Object)evictionPolicyConfig)).modernizeConfig());
    }

    public void setEvictionAlgorithmConfig(EvictionAlgorithmConfig config) {
        this.testImmutability("evictionAlgorithmConfig");
        this.evictionAlgorithmConfig = config;
    }

    public Fqn getRegionFqn() {
        return this.regionFqn;
    }

    public void setRegionFqn(Fqn regionFqn) {
        this.testImmutability("regionFqn");
        this.regionFqn = regionFqn;
    }

    public String getRegionName() {
        return this.regionFqn == null ? null : this.regionFqn.toString();
    }

    public void setRegionName(String name) {
        this.setRegionFqn(name == null ? null : Fqn.fromString(name));
    }

    public int getEventQueueSize() {
        return this.eventQueueSize == null ? 200000 : this.eventQueueSize;
    }

    public void setEventQueueSize(int queueSize) {
        this.testImmutability("eventQueueSize");
        if (queueSize <= 0) {
            LogFactory.getLog(EvictionRegionConfig.class).warn((Object)("Ignoring invalid queue capacity " + queueSize + " -- using " + 200000));
            queueSize = 200000;
        }
        this.eventQueueSize = queueSize;
    }

    public void setDefaults(EvictionRegionConfig defaults) {
        if (this.eventQueueSize == null) {
            this.eventQueueSize = defaults.getEventQueueSize();
        }
        if (this.evictionAlgorithmConfig == null) {
            this.evictionAlgorithmConfig = defaults.getEvictionAlgorithmConfig();
        }
        if (this.evictionActionPolicyClassName == null) {
            this.evictionActionPolicyClassName = defaults.getEvictionActionPolicyClassName();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof EvictionRegionConfig) {
            EvictionRegionConfig other = (EvictionRegionConfig)obj;
            boolean equalRegions = Util.safeEquals(this.regionFqn, other.regionFqn);
            boolean equalConfigurations = Util.safeEquals(this.evictionAlgorithmConfig, other.evictionAlgorithmConfig);
            boolean equalEventQueuSizes = this.getEventQueueSize() == other.getEventQueueSize();
            return equalRegions && equalConfigurations && equalConfigurations && equalEventQueuSizes;
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.regionFqn == null ? 0 : this.regionFqn.hashCode());
        return result;
    }

    public EvictionRegionConfig clone() throws CloneNotSupportedException {
        EvictionAlgorithmConfig evictionAlgorithmConfig;
        Method cloneMethod;
        EvictionRegionConfig clone = (EvictionRegionConfig)super.clone();
        if (this.evictionAlgorithmConfig != null) {
            if (this.evictionAlgorithmConfig instanceof ConfigurationComponent) {
                clone.setEvictionAlgorithmConfig((EvictionAlgorithmConfig)((ConfigurationComponent)((Object)this.evictionAlgorithmConfig)).clone());
            } else {
                try {
                    cloneMethod = this.evictionAlgorithmConfig.getClass().getDeclaredMethod("clone", new Class[0]);
                    evictionAlgorithmConfig = (EvictionAlgorithmConfig)cloneMethod.invoke((Object)this.evictionAlgorithmConfig, new Object[0]);
                    clone.setEvictionAlgorithmConfig(evictionAlgorithmConfig);
                }
                catch (Exception e) {
                    CloneNotSupportedException cnse = new CloneNotSupportedException("Cannot invoke clone() on " + this.evictionAlgorithmConfig);
                    cnse.initCause(e);
                    throw cnse;
                }
            }
        }
        if (this.deprecatedConfig != null) {
            if (!(this.deprecatedConfig instanceof Cloneable)) {
                throw new CloneNotSupportedException(this.deprecatedConfig + " is not Cloneable");
            }
            if (this.deprecatedConfig instanceof ConfigurationComponent) {
                clone.setEvictionAlgorithmConfig((EvictionAlgorithmConfig)((ConfigurationComponent)((Object)this.deprecatedConfig)).clone());
            } else {
                try {
                    cloneMethod = this.deprecatedConfig.getClass().getDeclaredMethod("clone", new Class[0]);
                    evictionAlgorithmConfig = (EvictionAlgorithmConfig)cloneMethod.invoke((Object)this.deprecatedConfig, new Object[0]);
                    clone.setEvictionAlgorithmConfig(evictionAlgorithmConfig);
                }
                catch (Exception e) {
                    CloneNotSupportedException cnse = new CloneNotSupportedException("Cannot invoke clone() on " + this.deprecatedConfig);
                    cnse.initCause(e);
                    throw cnse;
                }
            }
        }
        clone.evictionActionPolicyClassName = this.evictionActionPolicyClassName;
        return clone;
    }

    public boolean isDefaultRegion() {
        return this.regionFqn.isRoot();
    }

    public String getEvictionActionPolicyClassName() {
        return this.evictionActionPolicyClassName == null ? EvictionConfig.EVICTION_ACTION_POLICY_CLASS_DEFAULT : this.evictionActionPolicyClassName;
    }

    public void setEvictionActionPolicyClassName(String evictionActionPolicyClassName) {
        this.evictionActionPolicyClassName = evictionActionPolicyClassName;
    }

    public void setEventQueueSizeIfUnset(int eventQueueSize) {
        if (this.eventQueueSize == null) {
            this.eventQueueSize = eventQueueSize;
        }
    }

    public void validate() {
        if (this.eventQueueSize < 1) {
            throw new ConfigurationException("Eviction event queue size cannot be less than 1!");
        }
        if (this.evictionAlgorithmConfig == null) {
            throw new MissingPolicyException("Eviction algorithm configuration cannot be null!");
        }
        this.evictionAlgorithmConfig.validate();
    }

    public String toString() {
        return "EvictionRegionConfig{regionFqn=" + this.regionFqn + ", eventQueueSize=" + this.eventQueueSize + ", evictionAlgorithmConfig=" + this.evictionAlgorithmConfig + ", evictionActionPolicyClassName='" + this.evictionActionPolicyClassName + '\'' + '}';
    }
}

