/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.blip;

import java.io.IOException;
import org.apache.poi.hslf.blip.Bitmap;
import org.apache.poi.util.LittleEndian;

public class DIB
extends Bitmap {
    public static final int HEADER_SIZE = 14;

    public int getType() {
        return 7;
    }

    public int getSignature() {
        return 31360;
    }

    public byte[] getData() {
        byte[] data = super.getData();
        byte[] header = new byte[14];
        LittleEndian.putInt((byte[])header, (int)0, (int)19778);
        LittleEndian.putInt((byte[])header, (int)2, (int)data.length);
        LittleEndian.putInt((byte[])header, (int)6, (int)0);
        LittleEndian.putInt((byte[])header, (int)10, (int)2);
        byte[] dib = new byte[header.length + data.length];
        System.arraycopy(header, 0, dib, 0, header.length);
        System.arraycopy(data, 0, dib, header.length, data.length);
        return dib;
    }

    public void setData(byte[] data) throws IOException {
        byte[] dib = new byte[data.length - 14];
        System.arraycopy(data, 14, dib, 0, dib.length);
        super.setData(dib);
    }
}

