/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.StringValueEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.TextFunction;

public class Substitute
extends TextFunction {
    private static final int REPLACE_ALL = -1;

    public Eval evaluate(Eval[] operands, int srcCellRow, short srcCellCol) {
        ValueEval retval = null;
        String oldStr = null;
        String searchStr = null;
        String newStr = null;
        int numToReplace = -1;
        switch (operands.length) {
            default: {
                retval = ErrorEval.VALUE_INVALID;
            }
            case 4: {
                ValueEval fourthveval = this.singleOperandEvaluate(operands[3], srcCellRow, srcCellCol);
                if (fourthveval instanceof NumericValueEval) {
                    NumericValueEval numToReplaceEval = (NumericValueEval)fourthveval;
                    numToReplace = (int)numToReplaceEval.getNumberValue();
                    break;
                }
                retval = ErrorEval.VALUE_INVALID;
            }
            case 3: 
        }
        ValueEval firstveval = this.singleOperandEvaluate(operands[0], srcCellRow, srcCellCol);
        ValueEval secondveval = this.singleOperandEvaluate(operands[1], srcCellRow, srcCellCol);
        ValueEval thirdveval = this.singleOperandEvaluate(operands[2], srcCellRow, srcCellCol);
        if (firstveval instanceof StringValueEval && secondveval instanceof StringValueEval && thirdveval instanceof StringValueEval) {
            StringValueEval oldStrEval = (StringValueEval)firstveval;
            oldStr = oldStrEval.getStringValue();
            StringValueEval searchStrEval = (StringValueEval)secondveval;
            searchStr = searchStrEval.getStringValue();
            StringValueEval newStrEval = (StringValueEval)thirdveval;
            newStr = newStrEval.getStringValue();
        } else {
            retval = ErrorEval.VALUE_INVALID;
        }
        if (retval == null) {
            if (numToReplace != -1 && numToReplace < 1) {
                retval = ErrorEval.VALUE_INVALID;
            } else if (searchStr.length() == 0) {
                retval = new StringEval(oldStr);
            } else {
                StringBuffer strBuff = new StringBuffer();
                int startIndex = 0;
                int nextMatch = -1;
                for (int leftToReplace = numToReplace; (leftToReplace > 0 || numToReplace == -1) && (nextMatch = oldStr.indexOf(searchStr, startIndex)) != -1; --leftToReplace) {
                    strBuff.append(oldStr.substring(startIndex, nextMatch));
                    strBuff.append(newStr);
                    startIndex = nextMatch + searchStr.length();
                }
                if (startIndex < oldStr.length()) {
                    strBuff.append(oldStr.substring(startIndex));
                }
                retval = new StringEval(strBuff.toString());
            }
        }
        return retval;
    }
}

