/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.organization.idm;

import java.util.LinkedList;
import java.util.List;
import org.exoplatform.management.annotations.Impact;
import org.exoplatform.management.annotations.ImpactType;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.annotations.ManagedName;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.rest.annotations.RESTEndpoint;
import org.picketlink.idm.cache.APICacheProvider;
import org.picketlink.idm.spi.cache.IdentityStoreCacheProvider;

@Managed
@ManagedDescription(value="PicketLink IDM Cache Service")
@NameTemplate(value={@Property(key="name", value="plidmcache"), @Property(key="service", value="PicketLinkIDMCacheService")})
@RESTEndpoint(path="plidmcache")
public class PicketLinkIDMCacheService {
    private final List<APICacheProvider> apiCacheProviders = new LinkedList<APICacheProvider>();
    private final List<IdentityStoreCacheProvider> storeCacheProviders = new LinkedList<IdentityStoreCacheProvider>();

    public void register(APICacheProvider cacheProvider) {
        if (cacheProvider != null) {
            this.apiCacheProviders.add(cacheProvider);
        }
    }

    public void register(IdentityStoreCacheProvider cacheProvider) {
        if (cacheProvider != null) {
            this.storeCacheProviders.add(cacheProvider);
        }
    }

    @Managed
    @ManagedDescription(value="Ivalidate cache namespace")
    @Impact(value=ImpactType.WRITE)
    public void invalidate(@ManagedDescription(value="Cache namespace") @ManagedName(value="namespace") String namespace) {
        for (APICacheProvider aPICacheProvider : this.apiCacheProviders) {
            aPICacheProvider.invalidate(namespace);
        }
        for (IdentityStoreCacheProvider identityStoreCacheProvider : this.storeCacheProviders) {
            identityStoreCacheProvider.invalidate(namespace);
        }
    }

    @Managed
    @ManagedDescription(value="Ivalidate all caches")
    @Impact(value=ImpactType.WRITE)
    public void invalidateAll() {
        for (APICacheProvider aPICacheProvider : this.apiCacheProviders) {
            aPICacheProvider.invalidateAll();
        }
        for (IdentityStoreCacheProvider identityStoreCacheProvider : this.storeCacheProviders) {
            identityStoreCacheProvider.invalidateAll();
        }
    }
}

