/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.locks.ReentrantLock;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ReentrantLockTest
extends TestCase {
    ReentrantLock lock;

    public ReentrantLockTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.lock = new ReentrantLock();
    }

    public void tearDown() throws Exception {
        this.releaseAll(this.lock);
        this.lock = null;
        super.tearDown();
    }

    public void testAcquireLock() {
        this.lock.lock();
        ReentrantLockTest.assertEquals((int)1, (int)this.lock.getHoldCount());
        this.lock.lock();
        ReentrantLockTest.assertEquals((int)2, (int)this.lock.getHoldCount());
        this.release(this.lock);
        ReentrantLockTest.assertEquals((int)1, (int)this.lock.getHoldCount());
        this.release(this.lock);
        ReentrantLockTest.assertEquals((int)0, (int)this.lock.getHoldCount());
    }

    public void testAcquireLock2() {
        this.lock.lock();
        ReentrantLockTest.assertEquals((int)1, (int)this.lock.getHoldCount());
        this.lock.lock();
        ReentrantLockTest.assertEquals((int)2, (int)this.lock.getHoldCount());
        this.releaseAll(this.lock);
        ReentrantLockTest.assertEquals((int)0, (int)this.lock.getHoldCount());
    }

    private void release(ReentrantLock lock) {
        if (lock != null && lock.getHoldCount() > 0) {
            lock.unlock();
        }
    }

    private void releaseAll(ReentrantLock lock) {
        long holds;
        if (lock != null && (holds = (long)lock.getHoldCount()) > 0L) {
            int i = 0;
            while ((long)i < holds) {
                lock.unlock();
                ++i;
            }
        }
    }

    public static Test suite() {
        return new TestSuite(ReentrantLockTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)ReentrantLockTest.suite());
    }
}

