/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Stack;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Address;
import org.jgroups.ChannelException;
import org.jgroups.Header;
import org.jgroups.MergeView;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.blocks.RequestCorrelator;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.mux.MuxHeader;
import org.jgroups.mux.ServiceInfo;
import org.jgroups.protocols.COMPRESS;
import org.jgroups.protocols.ENCRYPT;
import org.jgroups.protocols.FC;
import org.jgroups.protocols.FD;
import org.jgroups.protocols.FD_SOCK;
import org.jgroups.protocols.FragHeader;
import org.jgroups.protocols.PingHeader;
import org.jgroups.protocols.PingRsp;
import org.jgroups.protocols.SEQUENCER;
import org.jgroups.protocols.TpHeader;
import org.jgroups.protocols.UNICAST;
import org.jgroups.protocols.UdpHeader;
import org.jgroups.protocols.VIEW_SYNC;
import org.jgroups.protocols.pbcast.GMS;
import org.jgroups.protocols.pbcast.JoinRsp;
import org.jgroups.protocols.pbcast.NakAckHeader;
import org.jgroups.protocols.pbcast.STABLE;
import org.jgroups.protocols.pbcast.STATE_TRANSFER;
import org.jgroups.stack.IpAddress;
import org.jgroups.util.Digest;
import org.jgroups.util.MutableDigest;
import org.jgroups.util.Streamable;
import org.jgroups.util.Util;

public class SizeTest
extends TestCase {
    public SizeTest(String name) {
        super(name);
    }

    public void testUdpHeader() throws Exception {
        SizeTest._testSize(new UdpHeader("DemoChannel"));
    }

    public void testTpHeader() throws Exception {
        SizeTest._testSize(new TpHeader("DemoChannel"));
    }

    public void testPingHeader() throws Exception {
        SizeTest._testSize(new PingHeader(1, null));
        IpAddress self = new IpAddress("127.0.0.1", 5555);
        PingRsp rsp = new PingRsp(self, self, true);
        SizeTest._testSize(new PingHeader(2, rsp));
    }

    public void testNakackHeader() throws Exception {
        SizeTest._testSize(new NakAckHeader(1, 322649L));
        SizeTest._testSize(new NakAckHeader(2, 100L, 104L, new IpAddress("127.0.0.1", 5655)));
        SizeTest._testSize(new NakAckHeader(3, 100L, 104L, new IpAddress("127.0.0.1", 5655)));
        SizeTest._testSize(new NakAckHeader(3, 322649L));
    }

    public void testFdHeaders() throws Exception {
        FD.FdHeader hdr = new FD.FdHeader(1);
        SizeTest._testSize(hdr);
        IpAddress a1 = new IpAddress("127.0.0.1", 5555);
        IpAddress a2 = new IpAddress("127.0.0.1", 6666);
        Vector<Address> suspects = new Vector<Address>();
        suspects.add(a1);
        suspects.add(a2);
        hdr = new FD.FdHeader(2, suspects, a1);
        SizeTest._testSize(hdr);
        FD_SOCK.FdHeader sockhdr = new FD_SOCK.FdHeader(13);
        SizeTest._testSize(sockhdr);
        sockhdr = new FD_SOCK.FdHeader(10, new IpAddress("127.0.0.1", 5555));
        SizeTest._testSize(sockhdr);
        HashSet<Address> tmp = new HashSet<Address>();
        tmp.add(a1);
        tmp.add(a2);
        sockhdr = new FD_SOCK.FdHeader(10, tmp);
        SizeTest._testSize(sockhdr);
        Hashtable<Address, IpAddress> cache = new Hashtable<Address, IpAddress>();
        cache.put(a1, a2);
        cache.put(a2, a1);
        sockhdr = new FD_SOCK.FdHeader(10, cache);
        SizeTest._testSize(sockhdr);
    }

    public void testFdSockHeaders() throws Exception {
        FD_SOCK.FdHeader hdr = new FD_SOCK.FdHeader(13);
        SizeTest._testSize(hdr);
        hdr = new FD_SOCK.FdHeader(13, new IpAddress("127.0.0.1", 4567));
        SizeTest._testSize(hdr);
        HashSet<Address> set = new HashSet<Address>();
        set.add(new IpAddress(3452));
        set.add(new IpAddress("127.0.0.1", 5000));
        hdr = new FD_SOCK.FdHeader(13, set);
        SizeTest._testSize(hdr);
        Hashtable<Address, IpAddress> map = new Hashtable<Address, IpAddress>();
        map.put(new IpAddress("127.0.0.1", 5000), new IpAddress(4553));
        map.put(new IpAddress("127.0.0.1", 6000), new IpAddress(4523));
        map.put(new IpAddress(7000), new IpAddress(4553));
        hdr = new FD_SOCK.FdHeader(13, map);
        SizeTest._testSize(hdr);
        hdr = new FD_SOCK.FdHeader(12, new IpAddress("127.0.0.1", 4567), new IpAddress("127.0.0.1", 4567));
        SizeTest._testSize(hdr);
    }

    public void testUnicastHeader() throws Exception {
        UNICAST.UnicastHeader hdr = new UNICAST.UnicastHeader(0, 322649L);
        SizeTest._testSize(hdr);
    }

    public void testStableHeader() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        HashMap<Address, Digest.Entry> map = new HashMap<Address, Digest.Entry>();
        map.put(addr, new Digest.Entry(100L, 200L, 205L));
        Digest digest = new Digest(map);
        STABLE.StableHeader hdr = new STABLE.StableHeader(1, digest);
        SizeTest._testSize(hdr);
        hdr = new STABLE.StableHeader(2, null);
        SizeTest._testSize(hdr);
    }

    public void testStableHeader2() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        MutableDigest digest = new MutableDigest(2);
        digest.add(addr, 100L, 200L, 205L);
        STABLE.StableHeader hdr = new STABLE.StableHeader(1, digest);
        SizeTest._testSize(hdr);
        hdr = new STABLE.StableHeader(2, null);
        SizeTest._testSize(hdr);
    }

    public void testSequencerHeader() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        SEQUENCER.SequencerHeader hdr = new SEQUENCER.SequencerHeader(1, addr, 1L);
        SizeTest._testSize(hdr);
        hdr = new SEQUENCER.SequencerHeader(2, null, -1L);
        SizeTest._testSize(hdr);
    }

    public void testAddressVector() throws Exception {
        Vector<IpAddress> v = new Vector<IpAddress>();
        SizeTest._testSize(v);
        v.add(new IpAddress(1111));
        SizeTest._testSize(v);
        v.add(new IpAddress(2222));
        SizeTest._testSize(v);
    }

    public void testViewId() throws Exception {
        ViewId vid = new ViewId();
        SizeTest._testSize(vid);
        vid = new ViewId(new IpAddress(5555));
        SizeTest._testSize(vid);
        vid = new ViewId(new IpAddress(5555), 322649L);
        SizeTest._testSize(vid);
    }

    public void testView() throws Exception {
        View v = new View();
        SizeTest._testSize(v);
        ViewId vid = new ViewId(new IpAddress(1111), 322649L);
        Vector<Address> mbrs = new Vector<Address>();
        v = new View(vid, mbrs);
        SizeTest._testSize(v);
        mbrs.add(new IpAddress(3333));
        SizeTest._testSize(v);
        mbrs.add(new IpAddress(1111));
        SizeTest._testSize(v);
    }

    public void testViewPayload() throws Exception {
        View v = new View();
        v.addPayload("name", "Bela Ban");
        SizeTest._testSize(v);
        ViewId vid = new ViewId(new IpAddress(1111), 322649L);
        Vector<Address> mbrs = new Vector<Address>();
        v = new View(vid, mbrs);
        v.addPayload("id", 322649);
        v.addPayload("name", "Michelle");
        SizeTest._testSize(v);
        mbrs.add(new IpAddress(3333));
        SizeTest._testSize(v);
        mbrs.add(new IpAddress(1111));
        SizeTest._testSize(v);
    }

    public void testMergeView() throws Exception {
        MergeView v = new MergeView();
        SizeTest._testSize(v);
        ViewId vid = new ViewId(new IpAddress(1111), 322649L);
        Vector<Address> mbrs = new Vector<Address>();
        v = new MergeView(vid, mbrs, null);
        SizeTest._testSize(v);
        mbrs.add(new IpAddress(3333));
        SizeTest._testSize(v);
        mbrs.add(new IpAddress(1111));
        SizeTest._testSize(v);
    }

    public void testMergeView2() throws Exception {
        IpAddress a = new IpAddress(1000);
        IpAddress b = new IpAddress(2000);
        IpAddress c = new IpAddress(3000);
        IpAddress d = new IpAddress(4000);
        IpAddress e = new IpAddress(5000);
        IpAddress f = new IpAddress(6000);
        Vector<Address> m1 = new Vector<Address>();
        Vector<Address> m2 = new Vector<Address>();
        Vector<Address> m3 = new Vector<Address>();
        Vector<Address> all = new Vector<Address>();
        Vector<View> subgroups = new Vector<View>();
        m1.add(a);
        m1.add(b);
        m1.add(c);
        m2.add(d);
        m3.add(e);
        m3.add(f);
        all.add(a);
        all.add(b);
        all.add(c);
        all.add(d);
        all.add(e);
        all.add(f);
        View v1 = new View(a, 1L, m1);
        View v2 = new View(d, 2L, m2);
        View v3 = new View(e, 3L, m3);
        subgroups.add(v1);
        subgroups.add(v2);
        subgroups.add(v3);
        MergeView view_all = new MergeView(a, 5L, all, subgroups);
        System.out.println("MergeView: " + view_all);
        SizeTest._testSize(view_all);
    }

    public void testMergeView3() throws Exception {
        IpAddress a = new IpAddress(1000);
        IpAddress b = new IpAddress(2000);
        IpAddress c = new IpAddress(3000);
        IpAddress d = new IpAddress(4000);
        IpAddress e = new IpAddress(5000);
        IpAddress f = new IpAddress(6000);
        Vector<Address> m1 = new Vector<Address>();
        Vector<Address> m2 = new Vector<Address>();
        Vector<Address> m3 = new Vector<Address>();
        Vector<Address> all = new Vector<Address>();
        Vector<View> subgroups = new Vector<View>();
        m1.add(a);
        m1.add(b);
        m1.add(c);
        m2.add(d);
        m3.add(e);
        m3.add(f);
        all.add(a);
        all.add(b);
        all.add(c);
        all.add(d);
        all.add(e);
        all.add(f);
        View v1 = new View(a, 1L, m1);
        MergeView v2 = new MergeView(d, 2L, m2, new Vector<View>());
        View v3 = new View(e, 3L, m3);
        MergeView v4 = new MergeView(e, 4L, m3, null);
        subgroups.add(v1);
        subgroups.add(v2);
        subgroups.add(v3);
        subgroups.add(v4);
        MergeView view_all = new MergeView(a, 5L, all, subgroups);
        System.out.println("MergeView: " + view_all);
        SizeTest._testSize(view_all);
    }

    public void testViewSyncHeader() throws Exception {
        IpAddress creator = new IpAddress("localhost", 12345);
        Vector<Address> members = new Vector<Address>();
        members.add(new IpAddress(5555));
        members.add(creator);
        View view = new View(creator, 322649L, members);
        VIEW_SYNC.ViewSyncHeader hdr = new VIEW_SYNC.ViewSyncHeader(1, view);
        SizeTest._testSize(hdr);
        view = new MergeView();
        hdr = new VIEW_SYNC.ViewSyncHeader(1, view);
        SizeTest._testSize(hdr);
        Vector<View> subgroups = new Vector<View>();
        subgroups.add(view);
        view = new MergeView(creator, 322649L, members, subgroups);
        hdr = new VIEW_SYNC.ViewSyncHeader(1, view);
        SizeTest._testSize(hdr);
    }

    public void testJoinRsp() throws Exception {
        Vector<Address> members = new Vector<Address>();
        members.add(new IpAddress(1111));
        members.add(new IpAddress(2222));
        View v = new View(new IpAddress(1234), 322649L, members);
        MutableDigest d = new MutableDigest(3);
        d.add(new IpAddress(3524), 1L, 2L, 3L);
        d.add(new IpAddress(1324), 3L, 4L, 5L);
        JoinRsp rsp = new JoinRsp();
        SizeTest._testSize(rsp);
        rsp = new JoinRsp(v, d);
        SizeTest._testSize(rsp);
        rsp = new JoinRsp("this is a failure");
        SizeTest._testSize(rsp);
    }

    public void testGmsHeader() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        GMS.GmsHeader hdr = new GMS.GmsHeader(1, addr);
        SizeTest._testSize(hdr);
        Vector<Address> members = new Vector<Address>();
        members.add(addr);
        members.add(addr);
        View v = new View(addr, 33L, members);
        hdr = new GMS.GmsHeader(2, v);
        SizeTest._testSize(hdr);
    }

    public void testFCHeader() throws Exception {
        FC.FcHeader hdr = new FC.FcHeader(1);
        SizeTest._testSize(hdr);
    }

    public void testFragHeader() throws Exception {
        FragHeader hdr = new FragHeader(322649L, 1, 10);
        SizeTest._testSize(hdr);
    }

    public void testCompressHeader() throws Exception {
        COMPRESS.CompressHeader hdr = new COMPRESS.CompressHeader(2002);
        SizeTest._testSize(hdr);
    }

    public void testStateHeader() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        STATE_TRANSFER.StateHeader hdr = new STATE_TRANSFER.StateHeader(1, addr, 322649L, null);
        SizeTest._testSize(hdr);
        hdr = new STATE_TRANSFER.StateHeader(1, addr, 322649L, null, "my_state");
        SizeTest._testSize(hdr);
        MutableDigest digest = new MutableDigest(2);
        digest.add(addr, 100L, 200L, 205L);
        digest.add(new IpAddress(2314), 102L, 104L, 105L);
        hdr = new STATE_TRANSFER.StateHeader(2, addr, 322649L, digest);
        SizeTest._testSize(hdr);
        hdr = new STATE_TRANSFER.StateHeader(2, addr, 322649L, digest, "my_state");
        SizeTest._testSize(hdr);
    }

    public void testEncryptHeader() throws Exception {
        ENCRYPT.EncryptHeader hdr = new ENCRYPT.EncryptHeader(1, null);
        SizeTest._testSize(hdr);
        hdr = new ENCRYPT.EncryptHeader(2, "Hello world");
        SizeTest._testSize(hdr);
    }

    public void testIpAddress() throws Exception {
        IpAddress addr = new IpAddress();
        SizeTest._testSize(addr);
    }

    public void testIpAddress1() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 5555);
        SizeTest._testSize(addr);
    }

    public void testIpAddressWithHighPort() throws Exception {
        IpAddress addr = new IpAddress("127.0.0.1", 65535);
        SizeTest._testSize(addr);
    }

    public void testIpAddress2() throws Exception {
        IpAddress addr = new IpAddress(3456);
        SizeTest._testSize(addr);
    }

    public void testIpAddress3() throws Exception {
        IpAddress addr = new IpAddress(5555, false);
        SizeTest._testSize(addr);
    }

    public void testIpAddressWithAdditionalData() throws Exception {
        IpAddress addr = new IpAddress(5555, false);
        addr.setAdditionalData("bela".getBytes());
        SizeTest._testSize(addr);
    }

    public void testRequestCorrelatorHeader() throws Exception {
        RequestCorrelator.Header hdr = new RequestCorrelator.Header(0, 322649L, false, "HelloWorld");
        SizeTest._testSize(hdr);
        hdr = new RequestCorrelator.Header(1, 322649L, true, "bla");
        LinkedList<Address> l = new LinkedList<Address>();
        l.add(new IpAddress(1111));
        l.add(new IpAddress(2222));
        hdr.dest_mbrs = l;
        hdr.callStack = new Stack();
        hdr.callStack.push(new IpAddress(2222));
        hdr.callStack.push(new IpAddress(3333));
        SizeTest._testSize(hdr);
        hdr = new RequestCorrelator.Header(1, 322649L, true, "bla");
        hdr.callStack = new Stack();
        hdr.callStack.push(new IpAddress(2222));
        hdr.callStack.push(new IpAddress(3333));
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(output);
        hdr.writeTo(out);
        out.flush();
        byte[] buf = output.toByteArray();
        out.close();
        ByteArrayInputStream input = new ByteArrayInputStream(buf);
        DataInputStream in = new DataInputStream(input);
        hdr = new RequestCorrelator.Header();
        hdr.readFrom(in);
        System.out.println("call stack is " + hdr.callStack);
        Address tmp = hdr.callStack.pop();
        SizeTest.assertEquals((Object)tmp, (Object)new IpAddress(3333));
        tmp = hdr.callStack.pop();
        SizeTest.assertEquals((Object)tmp, (Object)new IpAddress(2222));
        SizeTest.assertEquals((long)322649L, (long)hdr.id);
        SizeTest.assertTrue((boolean)hdr.rsp_expected);
        SizeTest.assertEquals((String)"bla", (String)hdr.corrName);
        SizeTest.assertEquals((byte)1, (byte)hdr.type);
    }

    public void testServiceInfo() throws Exception {
        ServiceInfo si = new ServiceInfo();
        SizeTest._testSize(si);
    }

    public void testMuxHeader() throws Exception {
        MuxHeader hdr = new MuxHeader();
        SizeTest._testSize(hdr);
        hdr = new MuxHeader("bla");
        SizeTest._testSize(hdr);
        ServiceInfo si = new ServiceInfo();
        hdr = new MuxHeader(si);
        SizeTest._testSize(hdr);
        SizeTest._testSize(new MuxHeader(si));
    }

    private static void _testSize(Header hdr) throws Exception {
        long size = hdr.size();
        byte[] serialized_form = Util.streamableToByteBuffer((Streamable)((Object)hdr));
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
    }

    private static void _testSize(VIEW_SYNC.ViewSyncHeader hdr) throws Exception {
        long size = hdr.size();
        byte[] serialized_form = Util.streamableToByteBuffer(hdr);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
        VIEW_SYNC.ViewSyncHeader hdr2 = (VIEW_SYNC.ViewSyncHeader)Util.streamableFromByteBuffer(VIEW_SYNC.ViewSyncHeader.class, serialized_form);
        int my_type = hdr.getType();
        int other_type = hdr2.getType();
        View my_view = hdr.getView();
        View other_view = hdr2.getView();
        System.out.println("my_type=" + my_type + ", other_type=" + other_type);
        System.out.println("my_view=" + my_view + ", other_view=" + other_view);
        SizeTest.assertEquals((int)my_type, (int)other_type);
        SizeTest.assertEquals((Object)my_view, (Object)other_view);
    }

    private static void _testSize(Address addr) throws Exception {
        long size = addr.size();
        byte[] serialized_form = Util.streamableToByteBuffer(addr);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
    }

    private static void _testSize(ViewId vid) throws Exception {
        long size = vid.serializedSize();
        byte[] serialized_form = Util.streamableToByteBuffer(vid);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
    }

    private static void _testSize(View v) throws Exception {
        long size = v.serializedSize();
        byte[] serialized_form = Util.streamableToByteBuffer(v);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
    }

    private static void _testSize(Collection coll) throws Exception {
        long size = Util.size(coll);
        byte[] serialized_form = Util.collectionToByteBuffer(coll);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
    }

    private static void _testSize(JoinRsp rsp) throws Exception {
        long size = rsp.serializedSize();
        byte[] serialized_form = Util.streamableToByteBuffer(rsp);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
    }

    private static void _testSize(ServiceInfo si) throws Exception {
        long size = si.size();
        byte[] serialized_form = Util.streamableToByteBuffer(si);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
    }

    private static void _testSize(MuxHeader hdr) throws Exception {
        long size = hdr.size();
        byte[] serialized_form = Util.streamableToByteBuffer(hdr);
        System.out.println("size=" + size + ", serialized size=" + serialized_form.length);
        SizeTest.assertEquals((long)serialized_form.length, (long)size);
    }

    public static Test suite() {
        return new TestSuite(SizeTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)SizeTest.suite());
    }

    static {
        try {
            ClassConfigurator.getInstance(true);
        }
        catch (ChannelException e) {
            e.printStackTrace();
        }
    }
}

