/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.caja;

import com.google.caja.lang.css.CssSchema;
import com.google.caja.parser.AbstractParseTreeNode;
import com.google.caja.parser.AncestorChain;
import com.google.caja.parser.Visitor;
import com.google.caja.parser.css.CssTree;
import com.google.caja.reporting.MessageQueue;
import com.google.caja.reporting.SimpleMessageQueue;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.caja.CajaCssParser;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CajaCssSanitizer {
    private static final Logger logger = Logger.getLogger(CajaCssSanitizer.class.getName());
    private static final Set<String> ALLOWED_URI_SCHEMES = ImmutableSet.of((Object[])new String[]{"http", "https"});
    private final CajaCssParser parser;
    private final CssSchema schema;

    @Inject
    public CajaCssSanitizer(CajaCssParser parser) {
        this.parser = parser;
        this.schema = CssSchema.getDefaultCss21Schema((MessageQueue)new SimpleMessageQueue());
    }

    public String sanitize(String content, Uri linkContext, LinkRewriter importRewriter, LinkRewriter imageRewriter) {
        try {
            CssTree.StyleSheet stylesheet = this.parser.parseDom(content);
            this.sanitize((CssTree)stylesheet, linkContext, importRewriter, imageRewriter);
            return this.parser.serialize(stylesheet);
        }
        catch (GadgetException ge) {
            logger.log(Level.INFO, "Failed to parse stylesheet", ge);
            return "";
        }
    }

    public void sanitize(Element styleElem, Uri linkContext, LinkRewriter importRewriter, LinkRewriter imageRewriter) {
        String content = null;
        try {
            CssTree.StyleSheet stylesheet = this.parser.parseDom(styleElem.getTextContent());
            this.sanitize((CssTree)stylesheet, linkContext, importRewriter, imageRewriter);
            content = this.parser.serialize(stylesheet);
        }
        catch (GadgetException ge) {
            logger.log(Level.INFO, "Failed to parse stylesheet", ge);
        }
        if (StringUtils.isEmpty(content)) {
            styleElem.getParentNode().removeChild(styleElem);
        } else {
            styleElem.setTextContent(content);
        }
    }

    public void sanitize(CssTree css, final Uri linkContext, final LinkRewriter importRewriter, final LinkRewriter imageRewriter) {
        css.acceptPreOrder(new Visitor(){

            public boolean visit(AncestorChain<?> ancestorChain) {
                if (ancestorChain.node instanceof CssTree.Property) {
                    if (!CajaCssSanitizer.this.schema.isPropertyAllowed(((CssTree.Property)ancestorChain.node).getPropertyName())) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Removing property " + ((CssTree.Property)ancestorChain.node).getPropertyName());
                        }
                        CajaCssSanitizer.clean(ancestorChain);
                    }
                } else if (ancestorChain.node instanceof CssTree.FunctionCall) {
                    if (!CajaCssSanitizer.this.schema.isFunctionAllowed(((CssTree.FunctionCall)ancestorChain.node).getName())) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Removing function " + ((CssTree.FunctionCall)ancestorChain.node).getName());
                        }
                        CajaCssSanitizer.clean(ancestorChain);
                    }
                } else if (ancestorChain.node instanceof CssTree.UriLiteral && !(ancestorChain.getParentNode() instanceof CssTree.Import)) {
                    String uri = ((CssTree.UriLiteral)ancestorChain.node).getValue();
                    if (CajaCssSanitizer.this.isValidUri(uri)) {
                        ((CssTree.UriLiteral)ancestorChain.node).setValue(imageRewriter.rewrite(uri, linkContext));
                    } else {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Removing invalid URI " + uri);
                        }
                        CajaCssSanitizer.clean(ancestorChain);
                    }
                } else if (ancestorChain.node instanceof CssTree.Import) {
                    CssTree.Import importDecl = (CssTree.Import)ancestorChain.node;
                    String uri = importDecl.getUri().getValue();
                    if (CajaCssSanitizer.this.isValidUri(uri)) {
                        importDecl.getUri().setValue(importRewriter.rewrite(uri, linkContext));
                    } else {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Removing invalid URI " + uri);
                        }
                        CajaCssSanitizer.clean(ancestorChain);
                    }
                }
                return true;
            }
        }, null);
    }

    private boolean isValidUri(String uri) {
        try {
            String scheme = Uri.parse((String)uri).getScheme();
            return StringUtils.isEmpty((String)scheme) || ALLOWED_URI_SCHEMES.contains(scheme.toLowerCase());
        }
        catch (RuntimeException re) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Failed to parse URI in CSS " + uri, re);
            }
            return false;
        }
    }

    private static void clean(AncestorChain<?> chain) {
        if (chain.node instanceof CssTree.Declaration || chain.node instanceof CssTree.Import) {
            ((AbstractParseTreeNode)chain.getParentNode()).removeChild(chain.node);
        } else {
            CajaCssSanitizer.clean(chain.parent);
        }
    }
}

