/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.parse.nekohtml;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.StringReader;
import org.apache.shindig.gadgets.GadgetException;
import org.apache.shindig.gadgets.parse.GadgetHtmlParser;
import org.cyberneko.html.parsers.DOMFragmentParser;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@Singleton
public class NekoHtmlParser
extends GadgetHtmlParser {
    private final DOMImplementation documentProvider;

    @Inject
    public NekoHtmlParser(DOMImplementation documentProvider) {
        this.documentProvider = documentProvider;
    }

    public Document parseDomImpl(String source) throws GadgetException {
        try {
            return this.parseDomInternal(source);
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, (Throwable)e);
        }
    }

    private Document parseDomInternal(String source) throws SAXException, IOException, GadgetException {
        if (NekoHtmlParser.attemptFullDocParseFirst(source)) {
            InputSource input = new InputSource(new StringReader(source));
            DOMParser parser = new DOMParser();
            parser.setProperty("http://apache.org/xml/properties/dom/document-class-name", (Object)"org.apache.xerces.dom.DocumentImpl");
            parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"default");
            parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"no-change");
            parser.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            parser.setFeature("http://cyberneko.org/html/features/scanner/notify-builtin-refs", true);
            parser.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            parser.parse(input);
            return parser.getDocument();
        }
        DocumentFragment fragment = this.parseFragmentImpl(source);
        this.normalizeFragment(fragment.getOwnerDocument(), fragment);
        return fragment.getOwnerDocument();
    }

    protected DocumentFragment parseFragmentImpl(String source) throws GadgetException {
        try {
            Document htmlDoc = this.documentProvider.createDocument(null, null, null);
            htmlDoc.setStrictErrorChecking(false);
            DocumentFragment fragment = htmlDoc.createDocumentFragment();
            InputSource input = new InputSource(new StringReader(source));
            DOMFragmentParser parser = new DOMFragmentParser();
            parser.setProperty("http://cyberneko.org/html/properties/names/elems", (Object)"default");
            parser.setFeature("http://cyberneko.org/html/features/document-fragment", true);
            parser.setProperty("http://cyberneko.org/html/properties/names/attrs", (Object)"no-change");
            parser.setFeature("http://apache.org/xml/features/scanner/notify-char-refs", true);
            parser.setFeature("http://cyberneko.org/html/features/scanner/notify-builtin-refs", true);
            parser.parse(input, fragment);
            return fragment;
        }
        catch (Exception e) {
            throw new GadgetException(GadgetException.Code.HTML_PARSE_ERROR, (Throwable)e);
        }
    }
}

