/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer.rightclick.manager;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Session;
import org.exoplatform.ecm.webui.component.explorer.UIJCRExplorer;
import org.exoplatform.ecm.webui.component.explorer.UIWorkingArea;
import org.exoplatform.ecm.webui.component.explorer.control.UIActionBar;
import org.exoplatform.ecm.webui.component.explorer.control.UIControl;
import org.exoplatform.ecm.webui.component.explorer.control.filter.CanSetPropertyFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsCheckedOutFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotInTrashFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotLockedFilter;
import org.exoplatform.ecm.webui.component.explorer.control.filter.IsNotTrashHomeNodeFilter;
import org.exoplatform.ecm.webui.component.explorer.control.listener.UIWorkingAreaActionListener;
import org.exoplatform.ecm.webui.component.explorer.popup.actions.UIRenameForm;
import org.exoplatform.ecm.webui.utils.JCRExceptionManager;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.ext.filter.UIExtensionFilter;
import org.exoplatform.webui.ext.filter.UIExtensionFilters;
import org.exoplatform.webui.ext.manager.UIAbstractManager;
import org.exoplatform.webui.ext.manager.UIAbstractManagerComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(events={@EventConfig(listeners={RenameActionListener.class})})
public class RenameManageComponent
extends UIAbstractManagerComponent {
    private static final List<UIExtensionFilter> FILTERS = Arrays.asList(new UIExtensionFilter[]{new IsNotInTrashFilter(), new IsNotInTrashFilter(), new CanSetPropertyFilter(), new IsNotLockedFilter(), new IsCheckedOutFilter(), new IsNotTrashHomeNodeFilter()});

    @UIExtensionFilters
    public List<UIExtensionFilter> getFilters() {
        return FILTERS;
    }

    public static void renameManage(Event<RenameManageComponent> event, UIJCRExplorer uiExplorer) throws Exception {
        UIWorkingArea uicomp = (UIWorkingArea)((RenameManageComponent)((Object)event.getSource())).getParent();
        String renameNodePath = event.getRequestContext().getRequestParameter("objectId");
        Matcher matcher = UIWorkingArea.FILE_EXPLORER_URL_SYNTAX.matcher(renameNodePath);
        String wsName = null;
        if (!matcher.find()) {
            throw new IllegalArgumentException("The ObjectId is invalid '" + renameNodePath + "'");
        }
        wsName = matcher.group(1);
        renameNodePath = matcher.group(2);
        uiExplorer.setIsHidePopup(false);
        UIApplication uiApp = (UIApplication)uicomp.getAncestorOfType(UIApplication.class);
        Session session = uiExplorer.getSessionByWorkspace(wsName);
        Node renameNode = null;
        try {
            renameNode = uiExplorer.getNodeByPath(renameNodePath, session, false);
            session = renameNode.getSession();
            wsName = renameNode.getSession().getWorkspace().getName();
        }
        catch (PathNotFoundException path) {
            uiApp.addMessage(new ApplicationMessage("UIPopupMenu.msg.path-not-found-exception", null, 1));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            return;
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            return;
        }
        try {
            UIControl uiControl = (UIControl)uiExplorer.getChild(UIControl.class);
            UIActionBar uiActionBar = (UIActionBar)uiControl.getChild(UIActionBar.class);
            UIRenameForm uiRenameForm = (UIRenameForm)uiActionBar.createUIComponent(UIRenameForm.class, null, null);
            uiRenameForm.update(renameNode);
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiExplorer.getChild(UIPopupContainer.class);
            UIPopupContainer2.activate((UIComponent)uiRenameForm, 700, 0);
            UIPopupContainer2.setRendered(true);
        }
        catch (Exception e) {
            JCRExceptionManager.process((UIApplication)uiApp, (Exception)e);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
            uiExplorer.updateAjax(event);
        }
    }

    public Class<? extends UIAbstractManager> getUIAbstractManagerClass() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RenameActionListener
    extends UIWorkingAreaActionListener<RenameManageComponent> {
        public void processEvent(Event<RenameManageComponent> event) throws Exception {
            UIJCRExplorer uiExplorer = (UIJCRExplorer)((RenameManageComponent)((Object)event.getSource())).getAncestorOfType(UIJCRExplorer.class);
            RenameManageComponent.renameManage(event, uiExplorer);
        }
    }
}

