/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.utils;

import java.security.AccessControlException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.core.ExtendedNode;

public class PermissionUtil {
    public static boolean canRead(Node node) throws RepositoryException {
        return PermissionUtil.checkPermission(node, "read");
    }

    public static boolean canAddNode(Node node) throws RepositoryException {
        return PermissionUtil.checkPermission(node, "add_node");
    }

    public static boolean canChangePermission(Node node) throws RepositoryException {
        return PermissionUtil.checkPermission(node, "add_node,set_property,remove");
    }

    public static boolean isAnyRole(Node node) throws RepositoryException {
        return PermissionUtil.checkPermission(node, SystemIdentity.ANY);
    }

    public static boolean canSetProperty(Node node) throws RepositoryException {
        return PermissionUtil.checkPermission(node, "set_property");
    }

    public static boolean canRemoveNode(Node node) throws RepositoryException {
        return PermissionUtil.checkPermission(node, "remove");
    }

    private static boolean checkPermission(Node node, String permissionType) throws RepositoryException {
        try {
            ((ExtendedNode)node).checkPermission(permissionType);
            return true;
        }
        catch (AccessControlException e) {
            return false;
        }
    }
}

