/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.core.renderers;

import java.text.Format;
import org.exoplatform.webui.core.renderers.ValueRenderer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormattableValueRenderer<V>
extends ValueRenderer<V> {
    private String cssClass;
    private Format formatPrototype;
    private final ThreadLocal<Format> format = new ThreadLocal<Format>(){

        @Override
        public Format get() {
            return (Format)FormattableValueRenderer.this.formatPrototype.clone();
        }
    };

    public FormattableValueRenderer(Format format, String cssClass) {
        this.formatPrototype = format;
        this.cssClass = cssClass;
    }

    @Override
    public String render(V value) {
        if (this.formatPrototype != null) {
            return this.format.get().format(value);
        }
        return super.render(value);
    }

    @Override
    public String getCSSClassFor(V value) {
        if (this.cssClass != null) {
            return this.cssClass;
        }
        return super.getCSSClassFor(value);
    }
}

