/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.webui.form.validator;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.exception.MessageException;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormDateTimeInput;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.validator.Validator;

public class DateTimeValidator
implements Validator {
    private static final String SPLIT_REGEX = "/|\\s+|:";
    private static final String DATETIME_REGEX = "^(\\d{1,2}\\/\\d{1,2}\\/\\d{1,4})\\s*(\\s+\\d{1,2}:\\d{1,2}:\\d{1,2})?$";

    public void validate(UIFormInput uiInput) throws Exception {
        String label;
        if (uiInput.getValue() == null || ((String)uiInput.getValue()).trim().length() == 0) {
            return;
        }
        String s = (String)uiInput.getValue();
        SimpleDateFormat stFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
        UIFormDateTimeInput uiDateInput = (UIFormDateTimeInput)uiInput;
        SimpleDateFormat sdf = new SimpleDateFormat(uiDateInput.getDatePattern_().trim());
        UIForm uiForm = ((UIComponent)((Object)uiInput)).getAncestorOfType(UIForm.class);
        try {
            label = uiForm.getId() + ".label." + uiInput.getName();
        }
        catch (Exception e) {
            label = uiInput.getName();
        }
        Object[] args = new Object[]{label, s};
        try {
            sdf.setLenient(false);
            sdf.parse(s);
        }
        catch (Exception e) {
            throw new MessageException(new ApplicationMessage("DateTimeValidator.msg.Invalid-input", args, 1));
        }
        if (s.matches(DATETIME_REGEX) && this.isValidDateTime(s)) {
            return;
        }
        throw new MessageException(new ApplicationMessage("DateTimeValidator.msg.Invalid-input", args, 1));
    }

    private boolean isValidDateTime(String dateTime) {
        String[] arr = dateTime.split(SPLIT_REGEX, 7);
        int valid = Integer.parseInt(arr[0]);
        if (valid < 1 || valid > 12) {
            return false;
        }
        GregorianCalendar date = new GregorianCalendar(Integer.parseInt(arr[2]), valid - 1, 1);
        if (Integer.parseInt(arr[1]) > ((Calendar)date).getActualMaximum(5)) {
            return false;
        }
        return arr.length <= 3 || Integer.parseInt(arr[3]) <= 23 && Integer.parseInt(arr[4]) <= 59 && Integer.parseInt(arr[5]) <= 59;
    }
}

