/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wsqa.httpclient;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import org.exoplatform.wsqa.httpclient.HttpClient;
import org.exoplatform.wsqa.httpclient.HttpPostFormRequestBody;
import org.exoplatform.wsqa.httpclient.HttpRequest;
import org.exoplatform.wsqa.httpclient.HttpRequestHeader;
import org.exoplatform.wsqa.httpclient.HttpResponse;
import org.exoplatform.wsqa.httpclient.URI;
import org.exoplatform.wsqa.httpclient.WebUnit;
import org.exoplatform.wsqa.httpclient.WebUnitExecuteContext;
import org.exoplatform.wsqa.httpclient.validator.Validator;

public class ExoHttpClient
extends HttpClient {
    public ExoHttpClient(String suiteName) {
        super(suiteName);
    }

    protected void execute(WebUnit unit, WebUnitExecuteContext context) throws Exception {
        HttpRequest request = this.createHttpRequest(unit);
        String setCookie = this.getCookie();
        if (setCookie != null) {
            request.getHeaders().setCookie(setCookie);
        }
        context.setRequest(request);
        Socket serverSocket = new Socket(request.getHeaders().getUri().getHost(), request.getHeaders().getUri().getPort());
        OutputStream toServer = serverSocket.getOutputStream();
        request.forward(toServer);
        toServer.flush();
        BufferedInputStream fromServer = new BufferedInputStream(serverSocket.getInputStream());
        HttpResponse response = new HttpResponse(fromServer, request.getHeaders().getUri());
        context.setResponse(response);
        List<Validator> validators = unit.getValidators();
        if (validators != null) {
            for (Validator validator : validators) {
                boolean test = validator.validate(context);
                if (test) continue;
                context.setError(true);
            }
        }
        toServer.close();
        ((InputStream)fromServer).close();
        serverSocket.close();
    }

    private HttpRequest createHttpRequest(WebUnit unit) throws Exception {
        HttpPostFormRequestBody body = null;
        URI uri = new URI(this.getScheme(), this.getHost(), this.getPort(), unit.getPathInfo(), unit.getParameters());
        HttpRequestHeader headers = new HttpRequestHeader();
        headers.setUri(uri);
        headers.setMethod(unit.getMethod());
        headers.setProtocol(this.getProtocol());
        if (unit.getContentType() != null) {
            headers.setContentType(unit.getContentType());
        }
        if (unit.getReferer() != null) {
            headers.setReferer(unit.getReferer());
        }
        if (unit.getMethod().equals("POST") && HttpPostFormRequestBody.isFormRequest(unit.getContentType())) {
            body = new HttpPostFormRequestBody(unit.getContentType(), unit.getBodyParameters());
        }
        HttpRequest request = new HttpRequest(headers, body);
        return request;
    }
}

