/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.upload;

import java.io.InputStream;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Iterator;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.fileupload.FileItem;
import org.exoplatform.services.jcr.webdav.WebDavService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Path(value="/services/upload")
public class UploadService {
    private static final String WEBDAV_CONTEXT = "jcr";
    private WebDavService webDavService;

    public UploadService(WebDavService webDavService) {
        this.webDavService = webDavService;
    }

    @POST
    public Response post(Iterator<FileItem> iterator, @Context UriInfo uriInfo) {
        HashMap<String, FileItem> requestItems = new HashMap<String, FileItem>();
        while (iterator.hasNext()) {
            FileItem item = iterator.next();
            String fieldName = item.getFieldName();
            requestItems.put(fieldName, item);
        }
        if (requestItems.get("file") == null) {
            return Response.serverError().build();
        }
        try {
            FileItem fileItem = (FileItem)requestItems.get("file");
            InputStream inputStream = fileItem.getInputStream();
            String location = ((FileItem)requestItems.get("location")).getString();
            location = URLDecoder.decode(location, "UTF-8");
            String prefix = uriInfo.getBaseUri().toASCIIString() + "/" + WEBDAV_CONTEXT + "/";
            if (!location.startsWith(prefix)) {
                return Response.serverError().build();
            }
            location = location.substring(prefix.length());
            String repositoryName = location.substring(0, location.indexOf("/"));
            String repoPath = location.substring(location.indexOf("/") + 1);
            String mimeType = ((FileItem)requestItems.get("mimeType")).getString();
            String nodeType = null;
            if (requestItems.get("nodeType") != null && "".equals(nodeType = ((FileItem)requestItems.get("nodeType")).getString())) {
                nodeType = null;
            }
            String jcrContentNodeType = null;
            if (requestItems.get("jcrContentNodeType") != null && "".equals(jcrContentNodeType = ((FileItem)requestItems.get("jcrContentNodeType")).getString())) {
                jcrContentNodeType = null;
            }
            MediaType mediaType = new MediaType(mimeType.split("/")[0], mimeType.split("/")[1]);
            return this.webDavService.put(repositoryName, repoPath, null, null, nodeType, jcrContentNodeType, null, mediaType, inputStream);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return Response.serverError().entity((Object)exc.getMessage()).build();
        }
    }
}

