/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.spi.basic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.xcmis.spi.BaseItemsIterator;
import org.xcmis.spi.ConstraintException;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.StorageException;
import org.xcmis.spi.TypeManager;
import org.xcmis.spi.TypeNotFoundException;
import org.xcmis.spi.basic.PropertyDefinitions;
import org.xcmis.spi.model.BaseType;
import org.xcmis.spi.model.ContentStreamAllowed;
import org.xcmis.spi.model.PropertyDefinition;
import org.xcmis.spi.model.TypeDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BasicTypeManager
implements TypeManager {
    protected final Map<String, TypeDefinition> types = new ConcurrentHashMap<String, TypeDefinition>();
    protected final Map<String, Set<String>> typeChildren = new ConcurrentHashMap<String, Set<String>>();

    public BasicTypeManager() {
        this.types.put("cmis:document", new TypeDefinition("cmis:document", BaseType.DOCUMENT, "cmis:document", "cmis:document", "", null, "cmis:document", "Cmis Document Type", true, true, false, false, false, false, false, false, null, null, ContentStreamAllowed.ALLOWED, null));
        this.typeChildren.put("cmis:document", new HashSet());
        this.types.put("cmis:folder", new TypeDefinition("cmis:folder", BaseType.FOLDER, "cmis:folder", "cmis:folder", "", null, "cmis:folder", "Cmis Folder type", true, true, false, false, false, false, false, false, null, null, ContentStreamAllowed.NOT_ALLOWED, null));
        this.typeChildren.put("cmis:folder", new HashSet());
    }

    @Override
    public String addType(TypeDefinition type) throws StorageException {
        TypeDefinition superType;
        if (this.types.get(type.getId()) != null) {
            throw new InvalidArgumentException("Type " + type.getId() + " already exists.");
        }
        if (type.getBaseId() == null) {
            throw new InvalidArgumentException("Base type id must be specified.");
        }
        if (type.getParentId() == null) {
            throw new InvalidArgumentException("Unable add root type. Parent type id must be specified");
        }
        try {
            superType = this.getTypeDefinition(type.getParentId(), true);
        }
        catch (TypeNotFoundException e) {
            throw new InvalidArgumentException("Specified parent type " + type.getParentId() + " does not exists.");
        }
        if (type.getPropertyDefinitions() != null) {
            for (PropertyDefinition<?> newDefinition : type.getPropertyDefinitions()) {
                PropertyDefinition<?> definition = superType.getPropertyDefinition(newDefinition.getId());
                if (definition == null) continue;
                throw new InvalidArgumentException("Property " + newDefinition.getId() + " already defined");
            }
        }
        HashMap m = new HashMap();
        for (PropertyDefinition<?> next : superType.getPropertyDefinitions()) {
            m.put(next.getId(), next);
        }
        if (type.getPropertyDefinitions() != null) {
            for (PropertyDefinition<?> next : type.getPropertyDefinitions()) {
                m.put(next.getId(), next);
            }
        }
        this.types.put(type.getId(), type);
        this.typeChildren.get(superType.getId()).add(type.getId());
        this.typeChildren.put(type.getId(), new HashSet());
        PropertyDefinitions.putAll(type.getId(), m);
        return type.getId();
    }

    @Override
    public ItemsIterator<TypeDefinition> getTypeChildren(String typeId, boolean includePropertyDefinitions) throws TypeNotFoundException {
        ArrayList<TypeDefinition> types = new ArrayList<TypeDefinition>();
        if (typeId == null) {
            for (String t : new String[]{"cmis:document", "cmis:folder"}) {
                types.add(this.getTypeDefinition(t, includePropertyDefinitions));
            }
        } else {
            if (this.types.get(typeId) == null) {
                throw new TypeNotFoundException("Type " + typeId + " does not exist.");
            }
            for (String t : this.typeChildren.get(typeId)) {
                types.add(this.getTypeDefinition(t, includePropertyDefinitions));
            }
        }
        return new BaseItemsIterator<TypeDefinition>(types);
    }

    @Override
    public TypeDefinition getTypeDefinition(String typeId, boolean includePropertyDefinition) throws TypeNotFoundException {
        TypeDefinition type = this.types.get(typeId);
        if (type == null) {
            throw new TypeNotFoundException("Type " + typeId + " does not exist.");
        }
        TypeDefinition copy = new TypeDefinition(type.getId(), type.getBaseId(), type.getQueryName(), type.getLocalName(), type.getLocalNamespace(), type.getParentId(), type.getDisplayName(), type.getDescription(), type.isCreatable(), type.isFileable(), type.isQueryable(), type.isFulltextIndexed(), type.isIncludedInSupertypeQuery(), type.isControllablePolicy(), type.isControllableACL(), type.isVersionable(), type.getAllowedSourceTypes(), type.getAllowedTargetTypes(), type.getContentStreamAllowed(), includePropertyDefinition ? PropertyDefinitions.getAll(typeId) : null);
        return copy;
    }

    @Override
    public void removeType(String typeId) throws TypeNotFoundException, ConstraintException, StorageException {
        TypeDefinition type = this.types.get(typeId);
        if (type == null) {
            throw new TypeNotFoundException("Type " + typeId + " does not exist.");
        }
        if (type.getParentId() == null) {
            throw new ConstraintException("Unable remove root type " + typeId);
        }
        if (this.typeChildren.get(typeId).size() > 0) {
            throw new ConstraintException("Unable remove type " + typeId + ". Type has descendant types.");
        }
        this.types.remove(typeId);
        this.typeChildren.get(type.getParentId()).remove(typeId);
        PropertyDefinitions.removeAll(typeId);
    }
}

