/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.organization;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import org.exoplatform.services.jcr.ext.organization.JCROrganizationServiceImpl;
import org.exoplatform.services.jcr.ext.organization.JCRUserListAccess;
import org.exoplatform.services.jcr.ext.organization.OrganizationServiceException;
import org.exoplatform.services.jcr.ext.organization.UserHandlerImpl;
import org.exoplatform.services.organization.User;

public class SimpleJCRUserListAccess
extends JCRUserListAccess {
    public SimpleJCRUserListAccess(JCROrganizationServiceImpl service) {
        super(service);
    }

    protected int getSize(Session session) throws Exception {
        try {
            Node storageNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users");
            return (int)storageNode.getNodes().getSize();
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not get list size", e);
        }
    }

    protected User[] load(Session session, int index, int length) throws Exception {
        if (index < 0) {
            throw new IllegalArgumentException("Illegal index: index must be a positive number");
        }
        if (length < 0) {
            throw new IllegalArgumentException("Illegal length: length must be a positive number");
        }
        User[] users = new User[length];
        try {
            Node storageNode = (Node)session.getItem(this.service.getStoragePath() + "/" + "exo:users");
            NodeIterator results = storageNode.getNodes();
            UserHandlerImpl uHandler = new UserHandlerImpl(this.service);
            int p = 0;
            int counter = 0;
            while (counter < length) {
                if (!results.hasNext()) {
                    throw new IllegalArgumentException("Illegal index or length: sum of the index and the length cannot be greater than the list size");
                }
                Node result = results.nextNode();
                if (p >= index) {
                    users[counter++] = uHandler.readObjectFromNode(result);
                }
                ++p;
            }
            return users;
        }
        catch (Exception e) {
            throw new OrganizationServiceException("Can not load users", e);
        }
    }
}

