/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DataContainer;
import org.jboss.cache.Fqn;
import org.jboss.cache.InternalNode;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.Node;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.factories.annotations.Inject;
import org.jboss.cache.factories.annotations.Start;
import org.jboss.cache.invocation.InvocationContextContainer;
import org.jboss.cache.jmx.annotations.ManagedAttribute;
import org.jboss.cache.lock.FqnLockManager;
import org.jboss.cache.lock.LockType;
import org.jboss.cache.util.concurrent.locks.LockContainer;
import org.jboss.cache.util.concurrent.locks.OwnableReentrantLock;
import org.jboss.cache.util.concurrent.locks.OwnableReentrantSharedLockContainer;
import org.jboss.cache.util.concurrent.locks.PerElementOwnableReentrantLockContainer;
import org.jboss.cache.util.concurrent.locks.PerElementReentrantLockContainer;
import org.jboss.cache.util.concurrent.locks.ReentrantSharedLockContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MVCCLockManager
extends FqnLockManager {
    LockContainer<Fqn> lockContainer;
    DataContainer dataContainer;
    private Set<Fqn> internalFqns;
    private CacheSPI<?, ?> cache;
    private TransactionManager transactionManager;
    private InvocationContextContainer invocationContextContainer;
    private static final Log log = LogFactory.getLog(MVCCLockManager.class);
    private static final boolean trace = log.isTraceEnabled();

    @Inject
    public void injectDependencies(DataContainer dataContainer, CacheSPI cache, TransactionManager transactionManager, InvocationContextContainer invocationContextContainer) {
        this.dataContainer = dataContainer;
        this.cache = cache;
        this.transactionManager = transactionManager;
        this.invocationContextContainer = invocationContextContainer;
    }

    @Start
    public void startLockManager() {
        this.lockContainer = this.configuration.isUseLockStriping() ? (this.transactionManager == null ? new ReentrantSharedLockContainer(this.configuration.getConcurrencyLevel()) : new OwnableReentrantSharedLockContainer(this.configuration.getConcurrencyLevel(), this.invocationContextContainer)) : (this.transactionManager == null ? new PerElementReentrantLockContainer(this.configuration.getConcurrencyLevel()) : new PerElementOwnableReentrantLockContainer(this.configuration.getConcurrencyLevel(), this.invocationContextContainer));
    }

    @Start
    public void setInternalFqns() {
        this.internalFqns = this.cache.getInternalFqns();
    }

    @Override
    public boolean lock(Fqn fqn, LockType lockType, Object owner) throws InterruptedException {
        if (lockType == LockType.READ) {
            return true;
        }
        if (trace) {
            log.trace((Object)("Attempting to lock " + fqn));
        }
        return this.lockContainer.acquireLock(fqn, this.lockAcquisitionTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean lock(Fqn fqn, LockType lockType, Object owner, long timeoutMillis) throws InterruptedException {
        if (lockType == LockType.READ) {
            return true;
        }
        if (trace) {
            log.trace((Object)("Attempting to lock " + fqn));
        }
        return this.lockContainer.acquireLock(fqn, this.lockAcquisitionTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean lockAndRecord(Fqn fqn, LockType lockType, InvocationContext ctx) throws InterruptedException {
        if (lockType == LockType.READ) {
            return true;
        }
        if (trace) {
            log.trace((Object)("Attempting to lock " + fqn));
        }
        if (this.lockContainer.acquireLock(fqn, ctx.getLockAcquisitionTimeout(this.lockAcquisitionTimeout), TimeUnit.MILLISECONDS)) {
            ctx.addLock(fqn);
            return true;
        }
        return false;
    }

    @Override
    public void unlock(Fqn fqn, Object owner) {
        block3: {
            if (trace) {
                log.trace((Object)("Attempting to unlock " + fqn));
            }
            try {
                this.lockContainer.releaseLock(fqn);
            }
            catch (IllegalMonitorStateException imse) {
                if (!trace) break block3;
                log.trace((Object)"Caught exception and ignoring.", (Throwable)imse);
            }
        }
    }

    @Override
    public void unlock(InvocationContext ctx) {
        List locks = ctx.getLocks();
        if (!locks.isEmpty()) {
            ListIterator it = locks.listIterator(locks.size());
            while (it.hasPrevious()) {
                Fqn f = (Fqn)it.previous();
                if (trace) {
                    log.trace((Object)("Attempting to unlock " + f));
                }
                try {
                    this.lockContainer.releaseLock(f);
                }
                catch (IllegalMonitorStateException imse) {
                    if (!trace) continue;
                    log.trace((Object)"Caught exception and ignoring.", (Throwable)imse);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lockRecursively(InternalNode node, long timeoutMillis, boolean excludeInternalFqns, InvocationContext ctx) throws InterruptedException {
        boolean locked;
        if (excludeInternalFqns && this.internalFqns.contains(node.getFqn())) {
            return true;
        }
        boolean bl = locked = ctx == null ? this.lock(node.getFqn(), LockType.WRITE, null, timeoutMillis) : this.lockAndRecord(node.getFqn(), LockType.WRITE, ctx);
        if (!locked) {
            return false;
        }
        boolean needToUnlock = false;
        ConcurrentMap children = node.getChildrenMap();
        try {
            for (InternalNode child : children.values()) {
                locked = this.lockRecursively(child, timeoutMillis, excludeInternalFqns, ctx);
                if (locked) continue;
                needToUnlock = true;
                break;
            }
        }
        finally {
            if (needToUnlock) {
                for (InternalNode child : children.values()) {
                    Fqn childFqn = child.getFqn();
                    this.unlock(childFqn, null);
                    if (ctx == null) continue;
                    ctx.removeLock(childFqn);
                }
                this.unlock(node.getFqn(), null);
                if (ctx != null) {
                    ctx.removeLock(node.getFqn());
                }
            }
        }
        return locked;
    }

    public boolean lockAll(NodeSPI node, LockType lockType, Object owner) throws InterruptedException {
        if (lockType == LockType.READ) {
            return true;
        }
        return this.lockRecursively(node.getDelegationTarget(), this.lockAcquisitionTimeout, false, null);
    }

    public boolean lockAll(NodeSPI node, LockType lockType, Object owner, long timeout) throws InterruptedException {
        if (lockType == LockType.READ) {
            return true;
        }
        return this.lockRecursively(node.getDelegationTarget(), timeout, false, null);
    }

    public boolean lockAll(NodeSPI node, LockType lockType, Object owner, long timeout, boolean excludeInternalFqns) throws InterruptedException {
        if (lockType == LockType.READ) {
            return true;
        }
        return this.lockRecursively(node.getDelegationTarget(), timeout, excludeInternalFqns, null);
    }

    public boolean lockAllAndRecord(NodeSPI node, LockType lockType, InvocationContext ctx) throws InterruptedException {
        if (lockType == LockType.READ) {
            return true;
        }
        return this.lockRecursively(node.getDelegationTarget(), ctx.getLockAcquisitionTimeout(this.lockAcquisitionTimeout), false, ctx);
    }

    @Override
    public boolean lockAllAndRecord(Fqn fqn, LockType lockType, InvocationContext ctx) throws InterruptedException {
        return this.lockRecursively(this.dataContainer.peekInternalNode(fqn, false), ctx.getLockAcquisitionTimeout(this.lockAcquisitionTimeout), false, ctx);
    }

    @Override
    public void unlockAll(NodeSPI<?, ?> node, Object owner) {
        Set children = node.getChildren();
        if (children != null) {
            for (Node child : children) {
                this.unlockAll((NodeSPI)child, null);
            }
        }
        this.unlock(node.getFqn(), null);
    }

    public void unlockAll(NodeSPI node) {
        this.unlockAll(node, null);
    }

    @Override
    public boolean ownsLock(Fqn fqn, LockType lockType, Object owner) {
        if (lockType == LockType.READ) {
            return false;
        }
        return this.lockContainer.ownsLock(fqn, owner);
    }

    @Override
    public boolean ownsLock(Fqn fqn, Object owner) {
        return this.lockContainer.ownsLock(fqn, owner);
    }

    @Override
    public boolean isLocked(Fqn fqn) {
        return this.lockContainer.isLocked(fqn);
    }

    public boolean isLocked(NodeSPI n, LockType lockType) {
        if (lockType == LockType.READ) {
            return false;
        }
        return this.lockContainer.isLocked(n.getFqn());
    }

    @Override
    public Object getWriteOwner(Fqn f) {
        if (this.lockContainer.isLocked(f)) {
            Lock l = this.lockContainer.getLock(f);
            if (l instanceof OwnableReentrantLock) {
                return ((OwnableReentrantLock)l).getOwner();
            }
            return null;
        }
        return null;
    }

    @Override
    public Collection<Object> getReadOwners(Fqn f) {
        return Collections.emptySet();
    }

    public String printLockInfo(NodeSPI node) {
        return this.printLockInfo();
    }

    @Override
    public String printLockInfo() {
        return this.lockContainer.toString();
    }

    @ManagedAttribute(name="concurrency level", writable=false, description="The concurrency level that the MVCC Lock Manager has been configured with.")
    public int getConcurrencyLevel() {
        return this.configuration.getConcurrencyLevel();
    }

    @ManagedAttribute(name="locks held", writable=false, description="The number of exclusive locks that are held.")
    public int getNumberOfLocksHeld() {
        return this.lockContainer.getNumLocksHeld();
    }

    @ManagedAttribute(name="locks held", writable=false, description="The number of exclusive locks that are available.")
    public int getNumberOfLocksAvailable() {
        return this.lockContainer.size() - this.lockContainer.getNumLocksHeld();
    }
}

