/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import java.io.InputStream;
import java.util.Calendar;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Row;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;

public class ResultNode
implements Node {
    private Node node;
    private float score;
    private String excerpt;

    public ResultNode(Node node, Row row) throws RepositoryException {
        this.node = node;
        Value excerpt = row.getValue("rep:excerpt(.)");
        this.excerpt = excerpt == null ? "" : excerpt.getString();
        this.score = row.getValue("jcr:score").getLong();
    }

    public Node getNode() {
        return this.node;
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public float getScore() {
        return this.score;
    }

    public void setScore(float score) {
        this.score = score;
    }

    public String getExcerpt() {
        return this.excerpt;
    }

    public String getEditor() {
        try {
            if (this.node.hasProperty("exo:owner")) {
                return this.node.getProperty("exo:owner").getString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void setExcerpt(String excerpt) {
        this.excerpt = excerpt;
    }

    public String getTitle() throws Exception {
        if (this.node.hasProperty("exo:title")) {
            return this.node.getProperty("exo:title").getString();
        }
        return this.node.getName();
    }

    public String getSummary() throws Exception {
        if (this.node.hasProperty("exo:summary")) {
            return this.node.getProperty("exo:summary").getString();
        }
        return null;
    }

    public void addMixin(String name) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        throw new ConstraintViolationException("Unsupported this method");
    }

    public Node addNode(String name) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        throw new ConstraintViolationException("Unsupported this method");
    }

    public Node addNode(String name, String type) throws ItemExistsException, PathNotFoundException, NoSuchNodeTypeException, LockException, VersionException, ConstraintViolationException, RepositoryException {
        throw new ConstraintViolationException("Unsupported this method");
    }

    public boolean canAddMixin(String name) throws NoSuchNodeTypeException, RepositoryException {
        throw new ConstraintViolationException("Unsupported this method");
    }

    public void cancelMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new ConstraintViolationException("Unsupported this method");
    }

    public Version checkin() throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        throw new ConstraintViolationException("Unsupported this method");
    }

    public void checkout() throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        throw new ConstraintViolationException("Unsupported this method");
    }

    public void doneMerge(Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        throw new ConstraintViolationException("Unsupported this method");
    }

    public Version getBaseVersion() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.node.getBaseVersion();
    }

    public String getCorrespondingNodePath(String nodePath) throws ItemNotFoundException, NoSuchWorkspaceException, AccessDeniedException, RepositoryException {
        return this.node.getCorrespondingNodePath(nodePath);
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        return this.node.getDefinition();
    }

    public int getIndex() throws RepositoryException {
        return this.node.getIndex();
    }

    public Lock getLock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        return this.node.getLock();
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        return this.node.getMixinNodeTypes();
    }

    public Node getNode(String name) throws PathNotFoundException, RepositoryException {
        return this.node.getNode(name);
    }

    public NodeIterator getNodes() throws RepositoryException {
        return this.node.getNodes();
    }

    public NodeIterator getNodes(String name) throws RepositoryException {
        return this.node.getNodes(name);
    }

    public Item getPrimaryItem() throws ItemNotFoundException, RepositoryException {
        return this.node.getPrimaryItem();
    }

    public NodeType getPrimaryNodeType() throws RepositoryException {
        return this.node.getPrimaryNodeType();
    }

    public PropertyIterator getProperties() throws RepositoryException {
        return this.node.getProperties();
    }

    public PropertyIterator getProperties(String name) throws RepositoryException {
        return this.node.getProperties(name);
    }

    public PropertyIterator getReferences() throws RepositoryException {
        return this.node.getReferences();
    }

    public String getUUID() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.node.getUUID();
    }

    public VersionHistory getVersionHistory() throws UnsupportedRepositoryOperationException, RepositoryException {
        return this.node.getVersionHistory();
    }

    public boolean hasNode(String name) throws RepositoryException {
        return this.node.hasNode(name);
    }

    public boolean hasNodes() throws RepositoryException {
        return this.node.hasNodes();
    }

    public boolean hasProperties() throws RepositoryException {
        return this.node.hasProperties();
    }

    public boolean hasProperty(String name) throws RepositoryException {
        return this.node.hasProperty(name);
    }

    public boolean holdsLock() throws RepositoryException {
        return this.node.holdsLock();
    }

    public boolean isCheckedOut() throws RepositoryException {
        return this.node.isCheckedOut();
    }

    public boolean isLocked() throws RepositoryException {
        return this.node.isLocked();
    }

    public boolean isNodeType(String type) throws RepositoryException {
        return this.node.isNodeType(type);
    }

    public Lock lock(boolean arg0, boolean arg1) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        throw new UnsupportedRepositoryOperationException("Unsupported this method");
    }

    public NodeIterator merge(String arg0, boolean arg1) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public void orderBefore(String arg0, String arg1) throws UnsupportedRepositoryOperationException, VersionException, ConstraintViolationException, ItemNotFoundException, LockException, RepositoryException {
        this.node.orderBefore(arg0, arg1);
    }

    public void removeMixin(String arg0) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public void restore(String arg0, boolean arg1) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public void restore(Version arg0, boolean arg1) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public void restore(Version arg0, String arg1, boolean arg2) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public void restoreByLabel(String arg0, boolean arg1) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property setProperty(String arg0, Value arg1) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property setProperty(String arg0, Value[] arg1) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property setProperty(String arg0, String[] arg1) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property setProperty(String arg0, String arg1) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property setProperty(String arg0, InputStream arg1) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property setProperty(String arg0, boolean arg1) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property setProperty(String arg0, double arg1) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property setProperty(String arg0, long arg1) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property setProperty(String arg0, Calendar arg1) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property setProperty(String arg0, Node arg1) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property setProperty(String arg0, Value arg1, int arg2) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property setProperty(String arg0, Value[] arg1, int arg2) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property setProperty(String arg0, String[] arg1, int arg2) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property setProperty(String arg0, String arg1, int arg2) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public void unlock() throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, InvalidItemStateException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public void update(String arg0) throws NoSuchWorkspaceException, AccessDeniedException, LockException, InvalidItemStateException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public void accept(ItemVisitor arg0) throws RepositoryException {
        this.node.accept(arg0);
    }

    public Item getAncestor(int arg0) throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.node.getAncestor(arg0);
    }

    public int getDepth() throws RepositoryException {
        return this.node.getDepth();
    }

    public String getName() throws RepositoryException {
        return this.node.getName();
    }

    public boolean isModified() {
        return this.node.isModified();
    }

    public boolean isNew() {
        return this.node.isNew();
    }

    public boolean isNode() {
        return this.node.isNode();
    }

    public boolean isSame(Item arg0) throws RepositoryException {
        return this.node.isSame(arg0);
    }

    public void refresh(boolean arg0) throws InvalidItemStateException, RepositoryException {
        this.node.refresh(arg0);
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public void save() throws AccessDeniedException, ItemExistsException, ConstraintViolationException, InvalidItemStateException, ReferentialIntegrityException, VersionException, LockException, NoSuchNodeTypeException, RepositoryException {
        throw new RepositoryException("Unsupported this method");
    }

    public Property getProperty(String arg0) throws PathNotFoundException, RepositoryException {
        return this.node.getProperty(arg0);
    }

    public Node getParent() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.node.getParent();
    }

    public String getPath() throws RepositoryException {
        return this.node.getPath();
    }

    public Session getSession() throws RepositoryException {
        return this.node.getSession();
    }

    public boolean equals(Object obj) {
        try {
            ResultNode resNode = (ResultNode)obj;
            if (this.node.getPath().equals(resNode.getNode().getPath())) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }
}

