/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.publication.lifecycle.simple;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.jcr.lock.LockException;
import javax.jcr.version.VersionException;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortletPreferences;
import org.exoplatform.portal.application.Preference;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.Query;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.pom.config.POMSession;
import org.exoplatform.portal.pom.config.POMSessionManager;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.ecm.publication.IncorrectStateUpdateLifecycleException;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.wcm.core.WCMConfigurationService;
import org.exoplatform.services.wcm.portal.LivePortalManagerService;
import org.exoplatform.services.wcm.publication.PublicationUtil;
import org.exoplatform.services.wcm.publication.WCMPublicationService;
import org.exoplatform.services.wcm.publication.WebpagePublicationPlugin;
import org.exoplatform.services.wcm.publication.lifecycle.simple.ui.UIPublishingPanel;
import org.exoplatform.services.wcm.publication.listener.navigation.NavigationEventListenerDelegate;
import org.exoplatform.services.wcm.publication.listener.page.PageEventListenerDelegate;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.form.UIForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimplePublicationPlugin
extends WebpagePublicationPlugin {
    public static final String DEFAULT_STATE = "draft";
    public static final String PUBLICATION = "publication:publication".intern();
    public static final String LIFECYCLE_PROP = "publication:lifecycleName".intern();
    public static final String CURRENT_STATE = "publication:currentState".intern();
    public static final String HISTORY = "publication:history".intern();
    public static final String WCM_PUBLICATION_MIXIN = "publication:simplePublication".intern();
    public static final String LIFECYCLE_NAME = "Simple publication".intern();
    private static final String LOCALE_FILE = "locale.services.publication.lifecycle.simple.SimplePublication".intern();
    public static final String IMG_PATH = "artifacts/".intern();
    private PageEventListenerDelegate pageEventListenerDelegate = new PageEventListenerDelegate(LIFECYCLE_NAME, ExoContainerContext.getCurrentContainer());
    private NavigationEventListenerDelegate navigationEventListenerDelegate = new NavigationEventListenerDelegate(LIFECYCLE_NAME, ExoContainerContext.getCurrentContainer());
    private static final int BUFFER_SIZE = 512;

    public String getLifecycleType() {
        return WCM_PUBLICATION_MIXIN;
    }

    public void addMixin(Node node) throws Exception {
        node.addMixin(WCM_PUBLICATION_MIXIN);
    }

    public boolean canAddMixin(Node node) throws Exception {
        List<String> runningPortals = this.getRunningPortals(node.getSession().getUserID());
        if (runningPortals.size() == 0) {
            throw new AccessControlException("Current user doesn't have access permission to any portal");
        }
        if (node.isLocked()) {
            throw new LockException("This node is locked");
        }
        if (!node.isCheckedOut()) {
            throw new VersionException("This node is checked-in");
        }
        return node.canAddMixin(WCM_PUBLICATION_MIXIN);
    }

    public void changeState(Node node, String newState, HashMap<String, String> context) throws IncorrectStateUpdateLifecycleException, Exception {
        Session session = node.getSession();
        node.setProperty(CURRENT_STATE, newState);
        PublicationService publicationService = (PublicationService)WCMCoreUtils.getService(PublicationService.class);
        if (newState.equals(DEFAULT_STATE)) {
            String lifecycleName = node.getProperty("publication:lifecycleName").getString();
            String[] logs = new String[]{new Date().toString(), DEFAULT_STATE, session.getUserID(), "PublicationService.SimplePublicationPlugin.changeState.enrolled", lifecycleName};
            publicationService.addLog(node, logs);
        } else if (newState.equals("published")) {
            String[] logs = new String[]{new Date().toString(), "published", session.getUserID(), "PublicationService.SimplePublicationPlugin.changeState.published"};
            publicationService.addLog(node, logs);
        } else if (newState.equals("enrolled")) {
            String[] logs = new String[]{new Date().toString(), "enrolled", session.getUserID(), "PublicationService.SimplePublicationPlugin.changeState.published"};
            publicationService.addLog(node, logs);
        } else {
            throw new Exception("WCMPublicationPlugin.changeState : Unknown state : " + node.getProperty(CURRENT_STATE).getString());
        }
        session.save();
    }

    public String[] getPossibleStates() {
        return new String[]{"enrolled", DEFAULT_STATE, "published"};
    }

    public byte[] getStateImage(Node node, Locale locale) throws IOException, FileNotFoundException, Exception {
        byte[] bytes = null;
        String fileName = "WCM".intern();
        String currentState = node.getProperty(CURRENT_STATE).getString();
        fileName = "published".equals(currentState) ? fileName + "Published" : fileName + "Unpublished";
        String fileNameLocalized = fileName + "_" + locale.getLanguage();
        String completeFileName = IMG_PATH + fileNameLocalized + ".gif";
        InputStream in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(completeFileName);
        if (in == null) {
            completeFileName = IMG_PATH + fileName + ".gif";
            in = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(completeFileName);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SimplePublicationPlugin.transfer(in, out);
        bytes = out.toByteArray();
        return bytes;
    }

    public static int transfer(InputStream in, OutputStream out) throws IOException {
        int total = 0;
        byte[] buffer = new byte[512];
        int bytesRead = in.read(buffer);
        while (bytesRead != -1) {
            out.write(buffer, 0, bytesRead);
            total += bytesRead;
            bytesRead = in.read(buffer);
        }
        return total;
    }

    public UIForm getStateUI(Node node, UIComponent component) throws Exception {
        UIPublishingPanel form = (UIPublishingPanel)component.createUIComponent(UIPublishingPanel.class, null, null);
        List<String> runningPortals = this.getRunningPortals(node.getSession().getUserID());
        String portalName = this.getPortalForContent(node);
        form.initPanel(node, portalName, runningPortals);
        return form;
    }

    public String getUserInfo(Node node, Locale locale) throws Exception {
        return null;
    }

    private List<String> getRunningPortals(String userId) throws Exception {
        POMSessionManager manager = (POMSessionManager)WCMCoreUtils.getService(POMSessionManager.class);
        POMSession session = null;
        if (manager.getSession() == null) {
            session = manager.openSession();
        }
        ArrayList<String> listPortalName = new ArrayList<String>();
        DataStorage service = (DataStorage)WCMCoreUtils.getService(DataStorage.class);
        Query query = new Query(null, null, null, null, PortalConfig.class);
        ListAccess pageList = service.find2(query);
        List portalConfigs = WCMCoreUtils.getAllElementsOfListAccess((ListAccess)pageList);
        UserACL userACL = (UserACL)WCMCoreUtils.getService(UserACL.class);
        for (PortalConfig portalConfig : portalConfigs) {
            if (!userACL.hasPermission(portalConfig)) continue;
            listPortalName.add(portalConfig.getName());
        }
        if (session != null) {
            session.close();
        }
        return listPortalName;
    }

    public void publishContentToPage(Node content, Page page) throws Exception {
        Application portlet = new Application(ApplicationType.PORTLET);
        portlet.setShowInfoBar(false);
        WCMConfigurationService configurationService = (WCMConfigurationService)WCMCoreUtils.getService(WCMConfigurationService.class);
        StringBuilder windowId = new StringBuilder();
        windowId.append("portal").append("#").append(Util.getUIPortal().getOwner()).append(":").append(configurationService.getRuntimeContextParam("SCVPortlet")).append("/").append(IdGenerator.generate());
        PortletPreferences portletPreferences = new PortletPreferences();
        portletPreferences.setWindowId(windowId.toString());
        ArrayList<Preference> listPreference = new ArrayList<Preference>();
        Preference preferenceR = new Preference();
        ArrayList<String> listValue = new ArrayList<String>();
        listValue.add(((ManageableRepository)content.getSession().getRepository()).getConfiguration().getName());
        preferenceR.setName("repository");
        preferenceR.setValues(listValue);
        listPreference.add(preferenceR);
        Preference preferenceW = new Preference();
        listValue = new ArrayList();
        listValue.add(content.getSession().getWorkspace().getName());
        preferenceW.setName("workspace");
        preferenceW.setValues(listValue);
        listPreference.add(preferenceW);
        Preference preferenceN = new Preference();
        listValue = new ArrayList();
        listValue.add(content.getUUID());
        preferenceN.setName("nodeIdentifier");
        preferenceN.setValues(listValue);
        listPreference.add(preferenceN);
        Preference preferenceQ = new Preference();
        listValue = new ArrayList();
        listValue.add("true");
        preferenceQ.setName("ShowQuickEdit");
        preferenceQ.setValues(listValue);
        listPreference.add(preferenceQ);
        portletPreferences.setPreferences(listPreference);
        DataStorage dataStorage = (DataStorage)WCMCoreUtils.getService(DataStorage.class);
        dataStorage.save(portletPreferences);
        dataStorage.save(page);
    }

    public void suspendPublishedContentFromPage(Node content, Page page) throws Exception {
        String pageId = page.getPageId();
        List mixedApplicationIDs = PublicationUtil.getValuesAsString((Node)content, (String)"publication:applicationIDs");
        ArrayList<String> removedApplicationIDs = new ArrayList<String>();
        for (String mixedID : mixedApplicationIDs) {
            if (!mixedID.startsWith(pageId)) continue;
            String realAppID = PublicationUtil.parseMixedApplicationId((String)mixedID)[1];
            removedApplicationIDs.add(realAppID);
        }
        if (removedApplicationIDs.size() == 0) {
            return;
        }
        PublicationUtil.removeApplicationFromPage((Page)page, removedApplicationIDs);
        ((DataStorage)WCMCoreUtils.getService(DataStorage.class)).save(page);
    }

    public List<String> getListPageNavigationUri(Page page, String remoteUser) throws Exception {
        ArrayList<String> listPageNavigationUri = new ArrayList<String>();
        DataStorage dataStorage = (DataStorage)WCMCoreUtils.getService(DataStorage.class);
        for (String portalName : this.getRunningPortals(remoteUser)) {
            Query query = new Query("portal", portalName, PageNavigation.class);
            ListAccess list = dataStorage.find2(query);
            List pageNavigations = WCMCoreUtils.getAllElementsOfListAccess((ListAccess)list);
            for (PageNavigation pageNavigation : pageNavigations) {
                List listPageNode = PublicationUtil.findPageNodeByPageId((PageNavigation)pageNavigation, (String)page.getPageId());
                for (PageNode pageNode : listPageNode) {
                    listPageNavigationUri.add(PublicationUtil.setMixedNavigationUri((String)portalName, (String)pageNode.getUri()));
                }
            }
        }
        return listPageNavigationUri;
    }

    private String getPortalForContent(Node contentNode) throws Exception {
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)WCMCoreUtils.getService(LivePortalManagerService.class);
        for (String portalPath : livePortalManagerService.getLivePortalsPath()) {
            if (!contentNode.getPath().startsWith(portalPath)) continue;
            return livePortalManagerService.getPortalNameByPath(portalPath);
        }
        return null;
    }

    private boolean isSharedPortal(String portalName) throws Exception {
        LivePortalManagerService livePortalManagerService = (LivePortalManagerService)WCMCoreUtils.getService(LivePortalManagerService.class);
        SessionProvider sessionProvider = WCMCoreUtils.getSystemSessionProvider();
        Node sharedPortal = livePortalManagerService.getLiveSharedPortal(sessionProvider);
        return sharedPortal.getName().equals(portalName);
    }

    public Node getNodeView(Node node, Map<String, Object> context) throws Exception {
        WCMPublicationService wcmPublicationService = (WCMPublicationService)WCMCoreUtils.getService(WCMPublicationService.class);
        String contentState = wcmPublicationService.getContentState(node);
        if ("obsolete".equals(contentState)) {
            return null;
        }
        if (context.get("filter-mode").equals("Edit")) {
            return node;
        }
        if (!DEFAULT_STATE.equals(contentState)) {
            return node;
        }
        return null;
    }

    public void updateLifecycleOnChangeNavigation(PageNavigation navigation, String remoteUser) throws Exception {
        this.navigationEventListenerDelegate.updateLifecycleOnChangeNavigation(navigation, remoteUser, (WebpagePublicationPlugin)this);
    }

    public void updateLifecycleOnRemovePage(Page page, String remoteUser) throws Exception {
        this.pageEventListenerDelegate.updateLifecycleOnRemovePage(page, remoteUser, (WebpagePublicationPlugin)this);
    }

    public void updateLifecyleOnChangePage(Page page, String remoteUser) throws Exception {
        this.pageEventListenerDelegate.updateLifecyleOnChangePage(page, remoteUser, (WebpagePublicationPlugin)this);
    }

    public void updateLifecyleOnCreateNavigation(PageNavigation navigation) throws Exception {
        this.navigationEventListenerDelegate.updateLifecyleOnCreateNavigation(navigation);
    }

    public void updateLifecyleOnCreatePage(Page page, String remoteUser) throws Exception {
        this.pageEventListenerDelegate.updateLifecyleOnCreatePage(page, remoteUser, (WebpagePublicationPlugin)this);
    }

    public void updateLifecyleOnRemoveNavigation(PageNavigation navigation) throws Exception {
        this.navigationEventListenerDelegate.updateLifecyleOnRemoveNavigation(navigation);
    }

    public String getLocalizedAndSubstituteMessage(Locale locale, String key, String[] values) throws Exception {
        ClassLoader cl = ((Object)((Object)this)).getClass().getClassLoader();
        ResourceBundle resourceBundle = ResourceBundle.getBundle(LOCALE_FILE, locale, cl);
        String result = "";
        try {
            result = resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            result = key;
        }
        if (values != null) {
            return String.format(result, values);
        }
        return result;
    }

    public void publishContentToCLV(Node content, Page page, String clvPortletId, String portalOwnerName, String remoteUser) throws Exception {
    }

    public void publishContentToSCV(Node content, Page page, String portalOwnerName) throws Exception {
    }

    public void suspendPublishedContentFromPage(Node content, Page page, String remoteUser) throws Exception {
    }

    public void updateLifecyleOnChangeContent(Node node, String remoteUser) throws Exception {
        this.updateLifecyleOnChangeContent(node, remoteUser, DEFAULT_STATE);
    }

    public void updateLifecyleOnChangeContent(Node node, String remoteUser, String newState) throws Exception {
        String state = node.getProperty(CURRENT_STATE).getString();
        if (DEFAULT_STATE.equalsIgnoreCase(state) && DEFAULT_STATE.equals(newState)) {
            return;
        }
        HashMap<String, String> context = new HashMap<String, String>();
        this.changeState(node, newState, context);
    }
}

