/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.gatein.common.util.AbstractTypedMap;
import org.gatein.common.util.ParameterValidation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParameterMap
extends AbstractTypedMap<String, String[], String, String[]>
implements Serializable {
    private static final KeyConverter keyConv = new KeyConverter();
    private AccessMode accessMode;
    private Map<String, String[]> delegate;

    public static ParameterMap clone(Map<String, String[]> map) throws NullPointerException, ClassCastException, IllegalArgumentException {
        return ParameterMap.clone(map, AccessMode.A);
    }

    public static ParameterMap clone(Map<String, String[]> map, AccessMode accessMode) throws NullPointerException, ClassCastException, IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNull(map, "map to be cloned");
        HashMap<String, String[]> delegate = new HashMap<String, String[]>(map);
        return new ParameterMap(delegate, accessMode);
    }

    public static ParameterMap wrap(Map<String, String[]> map) {
        return ParameterMap.wrap(map, AccessMode.A);
    }

    public static ParameterMap wrap(Map<String, String[]> map, AccessMode accessMode) {
        if (map instanceof ParameterMap) {
            return new ParameterMap((ParameterMap)map, accessMode);
        }
        return new ParameterMap(map, accessMode);
    }

    public ParameterMap() {
        this(AccessMode.A);
    }

    public ParameterMap(AccessMode accessMode) {
        this(new HashMap<String, String[]>(), accessMode);
    }

    public ParameterMap(Map<String, String[]> delegate) {
        this(delegate, AccessMode.A);
    }

    public ParameterMap(Map<String, String[]> delegate, AccessMode accessMode) {
        ParameterValidation.throwIllegalArgExceptionIfNull(delegate, "delegate");
        ParameterValidation.throwIllegalArgExceptionIfNull(accessMode, "access");
        this.delegate = delegate;
        this.accessMode = accessMode;
    }

    private ParameterMap(ParameterMap that, AccessMode accessMode) {
        this(that != null ? that.delegate : null, accessMode);
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public ParameterMap as(AccessMode accessMode) {
        return new ParameterMap(this, accessMode);
    }

    @Override
    public AbstractTypedMap.Converter<String, String> getKeyConverter() {
        return keyConv;
    }

    @Override
    public AbstractTypedMap.Converter<String[], String[]> getValueConverter() {
        return this.accessMode.converter;
    }

    @Override
    protected Map<String, String[]> getDelegate() {
        return this.delegate;
    }

    public String getValue(String name) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNull(name, "parameter name");
        String[] value = this.delegate.get(name);
        return value == null ? null : value[0];
    }

    public String[] getValues(String name) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNull(name, "parameter name");
        return (String[])this.get(name);
    }

    public void setValue(String name, String value) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNull(name, "parameter name");
        ParameterValidation.throwIllegalArgExceptionIfNull(value, "parrameter value");
        this.delegate.put(name, new String[]{value});
    }

    public void setValues(String name, String[] values) throws IllegalArgumentException {
        ParameterValidation.throwIllegalArgExceptionIfNull(name, "parameter name");
        ParameterValidation.throwIllegalArgExceptionIfNull(values, "parameter values");
        this.put(name, values);
    }

    public void append(Map<String, String[]> params) throws ClassCastException, NullPointerException, IllegalArgumentException {
        params = new HashMap<String, String[]>(params);
        for (Map.Entry<String, String[]> entry : params.entrySet()) {
            String[] appendedValue = entry.getValue();
            String[] existingValue = this.delegate.get(entry.getKey());
            if (existingValue != null) {
                String[] newValue = new String[existingValue.length + appendedValue.length];
                System.arraycopy(existingValue, 0, newValue, 0, existingValue.length);
                System.arraycopy(appendedValue, 0, newValue, existingValue.length, appendedValue.length);
                appendedValue = newValue;
            } else {
                appendedValue = (String[])appendedValue.clone();
            }
            entry.setValue(appendedValue);
        }
        this.putAll(params);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer("ParameterMap[");
        Iterator i = this.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            String name = (String)entry.getKey();
            String[] values = (String[])entry.getValue();
            buffer.append(name);
            for (int j = 0; j < values.length; ++j) {
                buffer.append(j > 0 ? (char)',' : '=').append(values[j]);
            }
            if (!i.hasNext()) continue;
            buffer.append(" | ");
        }
        buffer.append(']');
        return buffer.toString();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeBoolean(this.accessMode.copyValueOnRead);
        out.writeBoolean(this.accessMode.copyValueOnWrite);
        out.writeObject(this.delegate);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        boolean copyValueOnRead = in.readBoolean();
        boolean copyValueOnWrite = in.readBoolean();
        this.accessMode = AccessMode.get(copyValueOnRead, copyValueOnWrite);
        this.delegate = (Map)in.readObject();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ValueConverter
    extends AbstractTypedMap.Converter<String[], String[]> {
        private final AccessMode accessMode;

        private ValueConverter(AccessMode accessMode) {
            this.accessMode = accessMode;
        }

        @Override
        protected String[] getInternal(String[] external) throws IllegalArgumentException, ClassCastException, NullPointerException {
            if (external.length == 0) {
                throw new IllegalArgumentException("Array must not be zero length");
            }
            for (int i = external.length - 1; i >= 0; --i) {
                if (external[i] != null) continue;
                throw new IllegalArgumentException("No null entries allowed in String[]");
            }
            if (this.accessMode.copyValueOnWrite) {
                external = (String[])external.clone();
            }
            return external;
        }

        @Override
        protected String[] getExternal(String[] internal) {
            if (this.accessMode.copyValueOnRead) {
                internal = (String[])internal.clone();
            }
            return internal;
        }

        @Override
        protected boolean equals(String[] left, String[] right) {
            return Arrays.equals(left, right);
        }
    }

    public static class AccessMode {
        private static final AccessMode A = new AccessMode(false, false);
        private static final AccessMode B = new AccessMode(false, true);
        private static final AccessMode C = new AccessMode(true, false);
        private static final AccessMode D = new AccessMode(true, true);
        private final boolean copyValueOnRead;
        private final boolean copyValueOnWrite;
        private final ValueConverter converter;

        public static AccessMode get(boolean copyValueOnRead, boolean copyValueOnWrite) {
            return copyValueOnRead ? (copyValueOnWrite ? D : C) : (copyValueOnWrite ? B : A);
        }

        private AccessMode(boolean copyValueOnRead, boolean copyOnWrite) {
            this.copyValueOnRead = copyValueOnRead;
            this.copyValueOnWrite = copyOnWrite;
            this.converter = new ValueConverter(this);
        }

        public boolean getCopyValueOnRead() {
            return this.copyValueOnRead;
        }

        public boolean getCopyValueOnWrite() {
            return this.copyValueOnWrite;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class KeyConverter
    extends AbstractTypedMap.Converter<String, String> {
        private KeyConverter() {
        }

        @Override
        protected String getInternal(String external) throws IllegalArgumentException, ClassCastException {
            return external;
        }

        @Override
        protected String getExternal(String internal) {
            return internal;
        }

        @Override
        protected boolean equals(String left, String right) {
            return left.equals(right);
        }
    }
}

