/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.content;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.xcmis.search.content.InMemoryColumn;
import org.xcmis.search.content.InMemoryTable;
import org.xcmis.search.content.Schema;
import org.xcmis.search.model.Query;
import org.xcmis.search.model.constraint.Operator;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.value.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemorySchema
implements Schema {
    private final Map<SelectorName, Schema.Table> tables;

    public static Builder createBuilder() {
        return new Builder();
    }

    protected InMemorySchema(Map<SelectorName, Schema.Table> tables) {
        this.tables = Collections.unmodifiableMap(tables);
    }

    @Override
    public Schema.Table getTable(SelectorName name) {
        return this.tables.get(name);
    }

    public InMemorySchema with(Schema.Table table) {
        HashMap<SelectorName, Schema.Table> tables = new HashMap<SelectorName, Schema.Table>(this.tables);
        tables.put(table.getName(), table);
        return new InMemorySchema(tables);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Schema.Table table : this.tables.values()) {
            if (first) {
                first = false;
            } else {
                sb.append('\n');
            }
            sb.append(table);
        }
        return sb.toString();
    }

    public static class Builder {
        private final Map<SelectorName, InMemoryTable> tables = new HashMap<SelectorName, InMemoryTable>();
        private final Map<SelectorName, Query> viewDefinitions = new HashMap<SelectorName, Query>();

        protected Builder() {
        }

        public Builder addTable(String name, String ... columnNames) {
            Validate.notEmpty((String)name, (String)" name may not be empty");
            Validate.notEmpty((Object[])columnNames, (String)"columnNames may not be empty");
            ArrayList<Schema.Column> columns = new ArrayList<Schema.Column>();
            int i = 0;
            for (String columnName : columnNames) {
                Validate.notEmpty((String)columnName, (String)("columnName[" + i++ + "] may not be empty"));
                columns.add(new InMemoryColumn(columnName, PropertyType.STRING));
            }
            InMemoryTable table = new InMemoryTable(new SelectorName(name), columns);
            this.tables.put(table.getName(), table);
            return this;
        }

        public Builder addTable(String name, String[] columnNames, PropertyType[] types) {
            Validate.notEmpty((String)name, (String)" name may not be empty");
            Validate.notEmpty((Object[])columnNames, (String)" columnNames may not be empty");
            Validate.notEmpty((Object[])types, (String)" types may not be empty");
            Validate.isTrue((columnNames.length == types.length ? 1 : 0) != 0, (String)"columnNames.length should be equal types.length");
            ArrayList<Schema.Column> columns = new ArrayList<Schema.Column>();
            assert (columnNames.length == types.length);
            for (int i = 0; i != columnNames.length; ++i) {
                String columnName = columnNames[i];
                Validate.notEmpty((String)columnName, (String)(" columnName[" + i + "] may not be empty"));
                columns.add(new InMemoryColumn(columnName, types[i]));
            }
            InMemoryTable table = new InMemoryTable(new SelectorName(name), columns);
            this.tables.put(table.getName(), table);
            return this;
        }

        public Builder addColumn(String tableName, String columnName, PropertyType type) {
            Validate.notEmpty((String)tableName, (String)" tableName may not be empty");
            Validate.notEmpty((String)columnName, (String)" columnName may not be empty");
            Validate.notNull((Object)((Object)type), (String)" type may not be null");
            return this.addColumn(tableName, columnName, type, false, Operator.ALL);
        }

        public Builder addColumn(String tableName, String columnName, PropertyType type, boolean fullTextSearchable, Operator[] availableQueryOperators) {
            Validate.notEmpty((String)tableName, (String)" tableName may not be empty");
            Validate.notEmpty((String)columnName, (String)" columnName may not be empty");
            Validate.notNull((Object)((Object)type), (String)" type may not be null");
            SelectorName selector = new SelectorName(tableName);
            InMemoryTable existing = this.tables.get(selector);
            InMemoryTable table = null;
            if (existing == null) {
                ArrayList<Schema.Column> columns = new ArrayList<Schema.Column>();
                columns.add(new InMemoryColumn(columnName, type, fullTextSearchable, availableQueryOperators));
                table = new InMemoryTable(selector, columns);
            } else {
                table = existing.withColumn(columnName, type, fullTextSearchable, availableQueryOperators);
            }
            this.tables.put(table.getName(), table);
            return this;
        }

        public Builder makeSearchable(String tableName, String columnName) {
            Validate.notEmpty((String)tableName, (String)" tableName may not be empty");
            Validate.notEmpty((String)columnName, (String)" columnName may not be empty");
            SelectorName selector = new SelectorName(tableName);
            InMemoryTable existing = this.tables.get(selector);
            InMemoryTable table = null;
            if (existing == null) {
                ArrayList<Schema.Column> columns = new ArrayList<Schema.Column>();
                columns.add(new InMemoryColumn(columnName, PropertyType.STRING, true, Operator.ALL));
                table = new InMemoryTable(selector, columns);
            } else {
                Schema.Column column = existing.getColumn(columnName);
                PropertyType type = PropertyType.STRING;
                if (column != null) {
                    type = column.getPropertyType();
                }
                table = existing.withColumn(columnName, type, true, column.getAvailableQueryOperators());
            }
            this.tables.put(table.getName(), table);
            return this;
        }

        public Schema build() {
            InMemorySchema schemata = new InMemorySchema(new HashMap<SelectorName, Schema.Table>(this.tables));
            return schemata;
        }
    }
}

