/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.query;

import java.math.BigDecimal;
import java.net.URI;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.Validate;
import org.xcmis.search.QueryObjectModelVisitor;
import org.xcmis.search.VisitException;
import org.xcmis.search.Visitors;
import org.xcmis.search.model.Limit;
import org.xcmis.search.model.Query;
import org.xcmis.search.model.QueryElement;
import org.xcmis.search.model.column.Column;
import org.xcmis.search.model.constraint.And;
import org.xcmis.search.model.constraint.ChildNode;
import org.xcmis.search.model.constraint.Comparison;
import org.xcmis.search.model.constraint.Constraint;
import org.xcmis.search.model.constraint.DescendantNode;
import org.xcmis.search.model.constraint.FullTextSearch;
import org.xcmis.search.model.constraint.Not;
import org.xcmis.search.model.constraint.Operator;
import org.xcmis.search.model.constraint.Or;
import org.xcmis.search.model.constraint.PropertyExistence;
import org.xcmis.search.model.constraint.SameNode;
import org.xcmis.search.model.operand.BindVariableName;
import org.xcmis.search.model.operand.DynamicOperand;
import org.xcmis.search.model.operand.FullTextSearchScore;
import org.xcmis.search.model.operand.Length;
import org.xcmis.search.model.operand.Literal;
import org.xcmis.search.model.operand.LowerCase;
import org.xcmis.search.model.operand.NodeDepth;
import org.xcmis.search.model.operand.NodeLocalName;
import org.xcmis.search.model.operand.NodeName;
import org.xcmis.search.model.operand.PropertyValue;
import org.xcmis.search.model.operand.StaticOperand;
import org.xcmis.search.model.operand.UpperCase;
import org.xcmis.search.model.ordering.Order;
import org.xcmis.search.model.ordering.Ordering;
import org.xcmis.search.model.source.Join;
import org.xcmis.search.model.source.Selector;
import org.xcmis.search.model.source.SelectorName;
import org.xcmis.search.model.source.Source;
import org.xcmis.search.model.source.join.ChildNodeJoinCondition;
import org.xcmis.search.model.source.join.DescendantNodeJoinCondition;
import org.xcmis.search.model.source.join.EquiJoinCondition;
import org.xcmis.search.model.source.join.JoinCondition;
import org.xcmis.search.model.source.join.JoinType;
import org.xcmis.search.model.source.join.SameNodeJoinCondition;
import org.xcmis.search.value.CastSystem;
import org.xcmis.search.value.PropertyType;

public class QueryBuilder {
    protected final CastSystem castSystem;
    protected Source source = new Selector(new SelectorName("__not:defined__"));
    protected Constraint constraint;
    protected List<Column> columns = new LinkedList<Column>();
    protected List<Ordering> orderings = new LinkedList<Ordering>();
    protected Limit limit = Limit.NONE;
    protected boolean distinct;
    protected Query firstQuery;
    protected boolean firstQueryAll;

    public QueryBuilder(CastSystem castSystem) {
        Validate.notNull((Object)castSystem, (String)"The context argument may not be null");
        this.castSystem = castSystem;
    }

    public QueryBuilder clear() {
        return this.clear(true);
    }

    protected QueryBuilder clear(boolean clearFirstQuery) {
        this.source = new Selector(new SelectorName("__not:defined__"));
        this.constraint = null;
        this.columns = new LinkedList<Column>();
        this.orderings = new LinkedList<Ordering>();
        this.limit = Limit.NONE;
        this.distinct = false;
        if (clearFirstQuery) {
            this.firstQuery = null;
        }
        return this;
    }

    protected SelectorName selector(String name) {
        return new SelectorName(name.trim());
    }

    protected Selector namedSelector(String nameWithOptionalAlias) {
        String[] parts = nameWithOptionalAlias.split("\\sAS\\s");
        if (parts.length == 2) {
            return new Selector(this.selector(parts[0]), this.selector(parts[1]));
        }
        return new Selector(this.selector(parts[0]));
    }

    protected Column column(String nameExpression) {
        String[] parts = nameExpression.split("(?<!\\\\)\\.");
        for (int i = 0; i != parts.length; ++i) {
            parts[i] = parts[i].trim();
        }
        SelectorName name = null;
        String propertyName = null;
        String columnName = null;
        if (parts.length == 2) {
            name = this.selector(parts[0]);
            propertyName = parts[1];
            columnName = parts[1];
        } else if (this.source == null) {
            name = this.selector(parts[0]);
            propertyName = parts[0];
            columnName = parts[0];
        } else if (this.source instanceof Selector) {
            Selector selector = (Selector)this.source;
            name = selector.hasAlias() ? selector.getAlias() : selector.getName();
            propertyName = parts[0];
            columnName = parts[0];
        } else {
            throw new IllegalArgumentException("Column parts " + parts[0] + " must be scoped");
        }
        return new Column(name, propertyName, columnName);
    }

    public QueryBuilder selectStar() {
        this.columns.clear();
        return this;
    }

    public QueryBuilder select(String ... columnNames) {
        for (String expression : columnNames) {
            this.columns.add(this.column(expression));
        }
        return this;
    }

    public QueryBuilder selectDistinctStar() {
        this.distinct = true;
        return this.selectStar();
    }

    public QueryBuilder selectDistinct(String ... columnNames) {
        this.distinct = true;
        return this.select(columnNames);
    }

    public QueryBuilder from(String tableNameWithOptionalAlias) {
        Selector selector = this.namedSelector(tableNameWithOptionalAlias);
        SelectorName oldName = this.source instanceof Selector ? ((Selector)this.source).getName() : null;
        for (int i = 0; i != this.columns.size(); ++i) {
            Column old = this.columns.get(i);
            if (!old.getSelectorName().equals((Object)oldName)) continue;
            this.columns.set(i, new Column(selector.getAliasOrName(), old.getPropertyName(), old.getColumnName()));
        }
        this.source = selector;
        return this;
    }

    public ConstraintBuilder where() {
        return new ConstraintBuilder(null);
    }

    public JoinClause join(String tableName) {
        return this.innerJoin(tableName);
    }

    public JoinClause innerJoin(String tableName) {
        return new JoinClause(this.namedSelector(tableName), JoinType.INNER);
    }

    public JoinClause leftOuterJoin(String tableName) {
        return new JoinClause(this.namedSelector(tableName), JoinType.LEFT_OUTER);
    }

    public JoinClause rightOuterJoin(String tableName) {
        return new JoinClause(this.namedSelector(tableName), JoinType.RIGHT_OUTER);
    }

    public QueryBuilder limit(int rowLimit) {
        this.limit = this.limit.withRowLimit(rowLimit);
        return this;
    }

    public QueryBuilder offset(int offset) {
        this.limit = this.limit.withOffset(offset);
        return this;
    }

    public OrderByBuilder orderBy() {
        return new OrderByBuilder();
    }

    public Query query() {
        Query result = new Query(this.source, this.constraint, this.orderings, this.columns, this.limit);
        if (this.firstQuery != null) {
            // empty if block
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AndBuilder<T> {
        private final T object;

        protected AndBuilder(T object) {
            assert (object != null);
            this.object = object;
        }

        public T and() {
            return this.object;
        }
    }

    public class ComparisonBuilder {
        protected final DynamicOperand left;
        protected final ConstraintBuilder constraintBuilder;

        protected ComparisonBuilder(ConstraintBuilder constraintBuilder, DynamicOperand left) {
            this.left = left;
            this.constraintBuilder = constraintBuilder;
        }

        public RightHandSide is(Operator operator) {
            Validate.notNull((Object)operator, (String)"The operator argument may not be null");
            return new RightHandSide(this, operator);
        }

        public RightHandSide isEqualTo() {
            return this.is(Operator.EQUAL_TO);
        }

        public RightHandSide isNotEqualTo() {
            return this.is(Operator.NOT_EQUAL_TO);
        }

        public RightHandSide isGreaterThan() {
            return this.is(Operator.GREATER_THAN);
        }

        public RightHandSide isGreaterThanOrEqualTo() {
            return this.is(Operator.GREATER_THAN_OR_EQUAL_TO);
        }

        public RightHandSide isLessThan() {
            return this.is(Operator.LESS_THAN);
        }

        public RightHandSide isLessThanOrEqualTo() {
            return this.is(Operator.LESS_THAN_OR_EQUAL_TO);
        }

        public RightHandSide isLike() {
            return this.is(Operator.LIKE);
        }

        public ConstraintBuilder isVariable(Operator operator, String variableName) {
            Validate.notNull((Object)operator, (String)"The operator argument may not be null");
            return this.constraintBuilder.setConstraint((Constraint)new Comparison(this.left, operator, (StaticOperand)new BindVariableName(variableName)));
        }

        public ConstraintBuilder is(Operator operator, Object literal) {
            assert (operator != null);
            Literal value = literal instanceof Literal ? (Literal)literal : new Literal(literal);
            return this.constraintBuilder.setConstraint((Constraint)new Comparison(this.left, operator, (StaticOperand)value));
        }

        public ConstraintBuilder isEqualToVariable(String variableName) {
            return this.isVariable(Operator.EQUAL_TO, variableName);
        }

        public ConstraintBuilder isGreaterThanVariable(String variableName) {
            return this.isVariable(Operator.GREATER_THAN, variableName);
        }

        public ConstraintBuilder isGreaterThanOrEqualToVariable(String variableName) {
            return this.isVariable(Operator.GREATER_THAN_OR_EQUAL_TO, variableName);
        }

        public ConstraintBuilder isLessThanVariable(String variableName) {
            return this.isVariable(Operator.LESS_THAN, variableName);
        }

        public ConstraintBuilder isLessThanOrEqualToVariable(String variableName) {
            return this.isVariable(Operator.LESS_THAN_OR_EQUAL_TO, variableName);
        }

        public ConstraintBuilder isLikeVariable(String variableName) {
            return this.isVariable(Operator.LIKE, variableName);
        }

        public ConstraintBuilder isNotEqualToVariable(String variableName) {
            return this.isVariable(Operator.NOT_EQUAL_TO, variableName);
        }

        public ConstraintBuilder isEqualTo(Object literal) {
            return this.is(Operator.EQUAL_TO, literal);
        }

        public ConstraintBuilder isGreaterThan(Object literal) {
            return this.is(Operator.GREATER_THAN, literal);
        }

        public ConstraintBuilder isGreaterThanOrEqualTo(Object literal) {
            return this.is(Operator.GREATER_THAN_OR_EQUAL_TO, literal);
        }

        public ConstraintBuilder isLessThan(Object literal) {
            return this.is(Operator.LESS_THAN, literal);
        }

        public ConstraintBuilder isLessThanOrEqualTo(Object literal) {
            return this.is(Operator.LESS_THAN_OR_EQUAL_TO, literal);
        }

        public ConstraintBuilder isLike(Object literal) {
            return this.is(Operator.LIKE, literal);
        }

        public ConstraintBuilder isNotEqualTo(Object literal) {
            return this.is(Operator.NOT_EQUAL_TO, literal);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RightHandSide {
        protected final Operator operator;
        protected final ComparisonBuilder comparisonBuilder;

        protected RightHandSide(ComparisonBuilder comparisonBuilder, Operator operator) {
            this.operator = operator;
            this.comparisonBuilder = comparisonBuilder;
        }

        public ConstraintBuilder literal(String literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(int literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(long literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(float literal) {
            return this.comparisonBuilder.is(this.operator, Float.valueOf(literal));
        }

        public ConstraintBuilder literal(double literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(Calendar literal) {
            return this.comparisonBuilder.is(this.operator, literal.getTimeInMillis());
        }

        public ConstraintBuilder literal(URI literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(UUID literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(BigDecimal literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder literal(boolean literal) {
            return this.comparisonBuilder.is(this.operator, literal);
        }

        public ConstraintBuilder variable(String variableName) {
            return this.comparisonBuilder.is(this.operator, variableName);
        }

        public CastAs<ConstraintBuilder> cast(int literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(String literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(boolean literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(long literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(double literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(BigDecimal literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(Calendar literal) {
            return new CastAsRightHandSide(this, literal.getTimeInMillis());
        }

        public CastAs<ConstraintBuilder> cast(UUID literal) {
            return new CastAsRightHandSide(this, literal);
        }

        public CastAs<ConstraintBuilder> cast(URI literal) {
            return new CastAsRightHandSide(this, literal);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class CastAsRightHandSide
    extends CastAs<ConstraintBuilder> {
        private final RightHandSide rhs;

        protected CastAsRightHandSide(RightHandSide rhs, Object value) {
            super(value);
            this.rhs = rhs;
        }

        @Override
        public ConstraintBuilder as(PropertyType type) {
            return this.rhs.comparisonBuilder.is(this.rhs.operator, QueryBuilder.this.castSystem.cast(this.value, type));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class CastAs<ReturnType> {
        protected final Object value;

        protected CastAs(Object value) {
            this.value = value;
        }

        public abstract ReturnType as(PropertyType var1);

        public ReturnType asString() {
            return this.as(PropertyType.STRING);
        }

        public ReturnType asBoolean() {
            return this.as(PropertyType.BOOLEAN);
        }

        public ReturnType asLong() {
            return this.as(PropertyType.LONG);
        }

        public ReturnType asDouble() {
            return this.as(PropertyType.DOUBLE);
        }

        public ReturnType asDate() {
            return this.as(PropertyType.DATE);
        }

        public ReturnType asPath() {
            return this.as(PropertyType.PATH);
        }
    }

    protected class LowerCaser
    extends ConstraintBuilder {
        private final ConstraintBuilder delegate;

        protected LowerCaser(ConstraintBuilder delegate) {
            super(null);
            this.delegate = delegate;
        }

        protected ConstraintBuilder setConstraint(Constraint constraint) {
            Comparison comparison = (Comparison)constraint;
            return this.delegate.setConstraint((Constraint)new Comparison((DynamicOperand)new LowerCase(comparison.getOperand1()), comparison.getOperator(), comparison.getOperand2()));
        }
    }

    protected class UpperCaser
    extends ConstraintBuilder {
        private final ConstraintBuilder delegate;

        protected UpperCaser(ConstraintBuilder delegate) {
            super(null);
            this.delegate = delegate;
        }

        protected ConstraintBuilder setConstraint(Constraint constraint) {
            Comparison comparison = (Comparison)constraint;
            return this.delegate.setConstraint((Constraint)new Comparison((DynamicOperand)new UpperCase(comparison.getOperand1()), comparison.getOperator(), comparison.getOperand2()));
        }
    }

    public class ConstraintBuilder
    implements DynamicOperandBuilder {
        private final ConstraintBuilder parent;
        private Constraint constraint;
        private Constraint left;
        private boolean and;
        private boolean negateConstraint;

        protected ConstraintBuilder(ConstraintBuilder parent) {
            this.parent = parent;
        }

        public QueryBuilder end() {
            this.buildLogicalConstraint();
            QueryBuilder.this.constraint = this.constraint;
            return QueryBuilder.this;
        }

        public ConstraintBuilder openParen() {
            return new ConstraintBuilder(this);
        }

        public ConstraintBuilder closeParen() {
            Validate.notNull((Object)this.parent, (String)"Unexpected parent == null");
            this.buildLogicalConstraint();
            return this.parent.setConstraint(this.constraint);
        }

        public ConstraintBuilder and() {
            this.buildLogicalConstraint();
            this.left = this.constraint;
            this.constraint = null;
            this.and = true;
            return this;
        }

        public ConstraintBuilder or() {
            this.buildLogicalConstraint();
            this.left = this.constraint;
            this.constraint = null;
            this.and = false;
            return this;
        }

        public ConstraintBuilder not() {
            this.negateConstraint = true;
            return this;
        }

        protected ConstraintBuilder buildLogicalConstraint() {
            if (this.negateConstraint && this.constraint != null) {
                this.constraint = new Not(this.constraint);
                this.negateConstraint = false;
            }
            if (this.left != null && this.constraint != null) {
                if (this.and) {
                    if (this.left instanceof Or) {
                        Or previous = (Or)this.left;
                        this.constraint = new Or(previous.getLeft(), (Constraint)new And(previous.getRight(), this.constraint));
                    } else {
                        this.constraint = new And(this.left, this.constraint);
                    }
                } else {
                    this.constraint = new Or(this.left, this.constraint);
                }
                this.left = null;
            }
            return this;
        }

        public ConstraintBuilder isSameNode(String table, String asNodeAtPath) {
            return this.setConstraint((Constraint)new SameNode(QueryBuilder.this.selector(table), asNodeAtPath));
        }

        public ConstraintBuilder isChild(String childTable, String parentPath) {
            return this.setConstraint((Constraint)new ChildNode(QueryBuilder.this.selector(childTable), parentPath));
        }

        public ConstraintBuilder isBelowPath(String descendantTable, String ancestorPath) {
            return this.setConstraint((Constraint)new DescendantNode(QueryBuilder.this.selector(descendantTable), ancestorPath));
        }

        public ConstraintBuilder hasProperty(String table, String propertyName) {
            return this.setConstraint((Constraint)new PropertyExistence(QueryBuilder.this.selector(table), propertyName));
        }

        public ConstraintBuilder search(String table, String searchExpression) {
            return this.setConstraint((Constraint)new FullTextSearch(QueryBuilder.this.selector(table), null, searchExpression));
        }

        public ConstraintBuilder search(String table, String propertyName, String searchExpression) {
            return this.setConstraint((Constraint)new FullTextSearch(QueryBuilder.this.selector(table), propertyName, searchExpression));
        }

        protected ComparisonBuilder comparisonBuilder(DynamicOperand operand) {
            return new ComparisonBuilder(this, operand);
        }

        public ComparisonBuilder length(String table, String property) {
            return this.comparisonBuilder((DynamicOperand)new Length(new PropertyValue(QueryBuilder.this.selector(table), property)));
        }

        public ComparisonBuilder propertyValue(String table, String property) {
            return this.comparisonBuilder((DynamicOperand)new PropertyValue(QueryBuilder.this.selector(table), property));
        }

        public ComparisonBuilder fullTextSearchScore(String table) {
            return this.comparisonBuilder((DynamicOperand)new FullTextSearchScore(QueryBuilder.this.selector(table)));
        }

        public ComparisonBuilder depth(String table) {
            return this.comparisonBuilder((DynamicOperand)new NodeDepth(QueryBuilder.this.selector(table)));
        }

        public ComparisonBuilder nodeLocalName(String table) {
            return this.comparisonBuilder((DynamicOperand)new NodeLocalName(QueryBuilder.this.selector(table)));
        }

        public ComparisonBuilder nodeName(String table) {
            return this.comparisonBuilder((DynamicOperand)new NodeName(QueryBuilder.this.selector(table)));
        }

        public DynamicOperandBuilder upperCaseOf() {
            return new UpperCaser(this);
        }

        public DynamicOperandBuilder lowerCaseOf() {
            return new LowerCaser(this);
        }

        protected ConstraintBuilder setConstraint(Constraint constraint) {
            if (this.constraint != null && this.left == null) {
                this.and();
            }
            this.constraint = constraint;
            return this.buildLogicalConstraint();
        }
    }

    public static interface DynamicOperandBuilder {
        public ComparisonBuilder length(String var1, String var2);

        public ComparisonBuilder propertyValue(String var1, String var2);

        public ComparisonBuilder fullTextSearchScore(String var1);

        public ComparisonBuilder depth(String var1);

        public ComparisonBuilder nodeLocalName(String var1);

        public ComparisonBuilder nodeName(String var1);

        public DynamicOperandBuilder upperCaseOf();

        public DynamicOperandBuilder lowerCaseOf();
    }

    public class JoinClause {
        private final Selector rightSource;
        private final JoinType type;

        protected JoinClause(Selector rightTable, JoinType type) {
            this.rightSource = rightTable;
            this.type = type;
        }

        protected SelectorName nameOf(String tableName) {
            final SelectorName name = new SelectorName(tableName);
            if (this.rightSource.getAliasOrName().equals((Object)name)) {
                return name;
            }
            final AtomicBoolean notFound = new AtomicBoolean(true);
            try {
                Visitors.visit((QueryElement)QueryBuilder.this.source, (QueryObjectModelVisitor)new Visitors.AbstractModelVisitor(){

                    public void visit(Selector selector) {
                        if (notFound.get() && selector.getAliasOrName().equals((Object)name)) {
                            notFound.set(false);
                        }
                    }
                });
            }
            catch (VisitException e) {
                // empty catch block
            }
            if (notFound.get()) {
                throw new IllegalArgumentException("Expected \"" + tableName + "\" to be a valid table name or alias");
            }
            return name;
        }

        public QueryBuilder on(String columnEqualExpression) {
            String[] parts = columnEqualExpression.split("=");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Expected equality expression for columns, but found \"" + columnEqualExpression + "\"");
            }
            return this.createJoin((JoinCondition)new EquiJoinCondition(QueryBuilder.this.column(parts[0]), QueryBuilder.this.column(parts[1])));
        }

        public QueryBuilder onSameNode(String table1, String table2) {
            return this.createJoin((JoinCondition)new SameNodeJoinCondition(this.nameOf(table1), this.nameOf(table2)));
        }

        public QueryBuilder onDescendant(String ancestorTable, String descendantTable) {
            return this.createJoin((JoinCondition)new DescendantNodeJoinCondition(this.nameOf(ancestorTable), this.nameOf(descendantTable)));
        }

        public QueryBuilder onChildNode(String parentTable, String childTable) {
            return this.createJoin((JoinCondition)new ChildNodeJoinCondition(this.nameOf(parentTable), this.nameOf(childTable)));
        }

        protected QueryBuilder createJoin(JoinCondition condition) {
            QueryBuilder.this.source = new Join(QueryBuilder.this.source, this.type, (Source)this.rightSource, condition);
            return QueryBuilder.this;
        }
    }

    protected class SingleOrderByOperandBuilder
    implements OrderByOperandBuilder {
        private final Order order;
        private final OrderByBuilder builder;

        protected SingleOrderByOperandBuilder(OrderByBuilder builder, Order order) {
            this.order = order;
            this.builder = builder;
        }

        protected OrderByBuilder addOrdering(DynamicOperand operand) {
            Ordering ordering = new Ordering(operand, this.order);
            QueryBuilder.this.orderings.add(ordering);
            return this.builder;
        }

        public OrderByBuilder propertyValue(String table, String property) {
            return this.addOrdering((DynamicOperand)new PropertyValue(QueryBuilder.this.selector(table), property));
        }

        public OrderByBuilder length(String table, String property) {
            return this.addOrdering((DynamicOperand)new Length(new PropertyValue(QueryBuilder.this.selector(table), property)));
        }

        public OrderByBuilder fullTextSearchScore(String table) {
            return this.addOrdering((DynamicOperand)new FullTextSearchScore(QueryBuilder.this.selector(table)));
        }

        public OrderByBuilder depth(String table) {
            return this.addOrdering((DynamicOperand)new NodeDepth(QueryBuilder.this.selector(table)));
        }

        public OrderByBuilder nodeName(String table) {
            return this.addOrdering((DynamicOperand)new NodeName(QueryBuilder.this.selector(table)));
        }

        public OrderByBuilder nodeLocalName(String table) {
            return this.addOrdering((DynamicOperand)new NodeLocalName(QueryBuilder.this.selector(table)));
        }

        public OrderByOperandBuilder lowerCaseOf() {
            return new SingleOrderByOperandBuilder(this.builder, this.order){

                protected OrderByBuilder addOrdering(DynamicOperand operand) {
                    return super.addOrdering((DynamicOperand)new LowerCase(operand));
                }
            };
        }

        public OrderByOperandBuilder upperCaseOf() {
            return new SingleOrderByOperandBuilder(this.builder, this.order){

                protected OrderByBuilder addOrdering(DynamicOperand operand) {
                    return super.addOrdering((DynamicOperand)new UpperCase(operand));
                }
            };
        }
    }

    public class OrderByBuilder {
        protected OrderByBuilder() {
        }

        public OrderByOperandBuilder ascending() {
            return new SingleOrderByOperandBuilder(this, Order.ASCENDING);
        }

        public OrderByOperandBuilder descending() {
            return new SingleOrderByOperandBuilder(this, Order.DESCENDING);
        }

        public OrderByBuilder then() {
            return this;
        }

        public QueryBuilder end() {
            return QueryBuilder.this;
        }
    }

    public static interface OrderByOperandBuilder {
        public OrderByBuilder length(String var1, String var2);

        public OrderByBuilder propertyValue(String var1, String var2);

        public OrderByBuilder fullTextSearchScore(String var1);

        public OrderByBuilder depth(String var1);

        public OrderByBuilder nodeLocalName(String var1);

        public OrderByBuilder nodeName(String var1);

        public OrderByOperandBuilder upperCaseOf();

        public OrderByOperandBuilder lowerCaseOf();
    }
}

