/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.List;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.config.annotation.ComponentConfig;

@ComponentConfig(template="classpath:groovy/social/webui/space/UISpaceActivitiesDisplay.gtmpl")
public class UISpaceActivitiesDisplay
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UISpaceActivitiesDisplay.class);
    private Space space;
    private List<Activity> activityList;
    private UIActivitiesContainer uiActivitiesContainer;

    public void setSpace(Space space) throws Exception {
        this.space = space;
        this.init();
    }

    public Space getSpace() {
        return this.space;
    }

    private void init() throws Exception {
        if (this.space == null) {
            LOG.warn((Object)"space is null! Can not display spaceActivites");
            return;
        }
        Identity spaceIdentity = this.getIdentityManager().getOrCreateIdentity("space", this.space.getId());
        this.activityList = this.getActivityManager().getActivities(spaceIdentity);
        this.removeChild(UIActivitiesContainer.class);
        this.uiActivitiesContainer = (UIActivitiesContainer)this.addChild(UIActivitiesContainer.class, null, null);
        this.uiActivitiesContainer.setPostContext(UIComposer.PostContext.SPACE);
        this.uiActivitiesContainer.setSpace(this.space);
        this.uiActivitiesContainer.setActivityList(this.activityList);
    }

    private IdentityManager getIdentityManager() {
        return (IdentityManager)this.getApplicationComponent(IdentityManager.class);
    }

    private ActivityManager getActivityManager() {
        return (ActivityManager)this.getApplicationComponent(ActivityManager.class);
    }
}

