/*
 * Decompiled with CFR 0.152.
 */
package org.jcrom.dao;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Session;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.jcrom.JcrMappingException;
import org.jcrom.Jcrom;
import org.jcrom.dao.JcrDAO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJcrDAO<T>
implements JcrDAO<T> {
    protected final Jcrom jcrom;
    protected final Session session;
    protected final Class<T> entityClass;
    protected final String[] mixinTypes;
    protected final boolean isVersionable;

    public AbstractJcrDAO(Class<T> entityClass, Session session, Jcrom jcrom) {
        this(entityClass, session, jcrom, new String[0]);
    }

    public AbstractJcrDAO(Class<T> entityClass, Session session, Jcrom jcrom, String[] mixinTypes) {
        this.entityClass = entityClass;
        this.session = session;
        this.jcrom = jcrom;
        this.mixinTypes = new String[mixinTypes.length];
        System.arraycopy(mixinTypes, 0, this.mixinTypes, 0, mixinTypes.length);
        this.isVersionable = this.checkIfVersionable();
    }

    private boolean checkIfVersionable() {
        for (String mixinType : this.mixinTypes) {
            if (!mixinType.equals("mix:versionable")) continue;
            return true;
        }
        return false;
    }

    protected String relativePath(String absolutePath) {
        if (absolutePath.startsWith("/")) {
            return absolutePath.substring(1);
        }
        return absolutePath;
    }

    @Override
    public Node create(T entity) throws Exception {
        String entityName = this.jcrom.getName(entity);
        if (entityName == null || entityName.equals("")) {
            throw new JcrMappingException("The name of the entity being created is empty!");
        }
        String parentPath = this.jcrom.getPath(entity);
        if (parentPath == null || parentPath.equals("")) {
            throw new JcrMappingException("The parent path of the entity being created is empty!");
        }
        Node parentNode = this.session.getRootNode().getNode(this.relativePath(parentPath));
        Node newNode = this.jcrom.addNode(parentNode, entity, this.mixinTypes);
        this.session.save();
        if (this.isVersionable) {
            newNode.checkin();
        }
        return newNode;
    }

    @Override
    public String update(T entity) throws Exception {
        return this.update(entity, "*", -1);
    }

    @Override
    public String update(T entity, String childNodeFilter, int maxDepth) throws Exception {
        Node node = this.session.getRootNode().getNode(this.relativePath(this.jcrom.getPath(entity)));
        return this.update(node, entity, childNodeFilter, maxDepth);
    }

    @Override
    public String updateByUUID(T entity, String uuid) throws Exception {
        return this.updateByUUID(entity, uuid, "*", -1);
    }

    @Override
    public String updateByUUID(T entity, String uuid, String childNodeFilter, int maxDepth) throws Exception {
        Node node = this.session.getNodeByUUID(uuid);
        return this.update(node, entity, childNodeFilter, maxDepth);
    }

    protected String update(Node node, T entity, String childNodeFilter, int maxDepth) throws Exception {
        if (this.isVersionable) {
            node.checkout();
        }
        String name = this.jcrom.updateNode(node, entity, childNodeFilter, maxDepth);
        this.session.save();
        if (this.isVersionable) {
            node.checkin();
        }
        return name;
    }

    @Override
    public void delete(String path) throws Exception {
        this.session.getRootNode().getNode(this.relativePath(path)).remove();
        this.session.save();
    }

    @Override
    public void deleteByUUID(String uuid) throws Exception {
        this.session.getNodeByUUID(uuid).remove();
        this.session.save();
    }

    @Override
    public boolean exists(String path) throws Exception {
        return this.session.getRootNode().hasNode(this.relativePath(path));
    }

    @Override
    public T get(String path) throws Exception {
        return this.get(path, "*", -1);
    }

    @Override
    public T get(String path, String childNodeFilter, int maxDepth) throws Exception {
        if (this.exists(path)) {
            Node node = this.session.getRootNode().getNode(this.relativePath(path));
            return this.jcrom.fromNode(this.entityClass, node, childNodeFilter, maxDepth);
        }
        return null;
    }

    @Override
    public T loadByUUID(String uuid) throws Exception {
        return this.loadByUUID(uuid, "*", -1);
    }

    @Override
    public T loadByUUID(String uuid, String childNodeFilter, int maxDepth) throws Exception {
        Node node = this.session.getNodeByUUID(uuid);
        return this.jcrom.fromNode(this.entityClass, node, childNodeFilter, maxDepth);
    }

    @Override
    public T getVersion(String path, String versionName) throws Exception {
        return this.getVersion(path, versionName, "*", -1);
    }

    @Override
    public T getVersion(String path, String versionName, String childNodeFilter, int maxDepth) throws Exception {
        return this.getVersion(this.session.getRootNode().getNode(this.relativePath(path)), versionName, childNodeFilter, maxDepth);
    }

    @Override
    public T getVersionByUUID(String uuid, String versionName) throws Exception {
        return this.getVersionByUUID(uuid, versionName, "*", -1);
    }

    @Override
    public T getVersionByUUID(String uuid, String versionName, String childNodeFilter, int maxDepth) throws Exception {
        return this.getVersion(this.session.getNodeByUUID(uuid), versionName, childNodeFilter, maxDepth);
    }

    protected T getVersion(Node node, String versionName, String childNodeFilter, int maxDepth) throws Exception {
        VersionHistory versionHistory = node.getVersionHistory();
        Version version = versionHistory.getVersion(versionName);
        return this.jcrom.fromNode(this.entityClass, version.getNodes().nextNode(), childNodeFilter, maxDepth);
    }

    @Override
    public void restoreVersion(String path, String versionName) throws Exception {
        this.restoreVersion(this.session.getRootNode().getNode(this.relativePath(path)), versionName);
    }

    @Override
    public void restoreVersionByUUID(String uuid, String versionName) throws Exception {
        this.restoreVersion(this.session.getNodeByUUID(uuid), versionName);
    }

    protected void restoreVersion(Node node, String versionName) throws Exception {
        node.checkout();
        node.restore(versionName, true);
    }

    @Override
    public void removeVersion(String path, String versionName) throws Exception {
        this.removeVersion(this.session.getRootNode().getNode(this.relativePath(path)), versionName);
    }

    @Override
    public void removeVersionByUUID(String uuid, String versionName) throws Exception {
        this.removeVersion(this.session.getNodeByUUID(uuid), versionName);
    }

    protected void removeVersion(Node node, String versionName) throws Exception {
        node.getVersionHistory().removeVersion(versionName);
    }

    @Override
    public long getVersionSize(String path) throws Exception {
        return this.getVersionSize(this.session.getRootNode().getNode(this.relativePath(path)));
    }

    @Override
    public long getVersionSizeByUUID(String uuid) throws Exception {
        return this.getVersionSize(this.session.getNodeByUUID(uuid));
    }

    protected long getVersionSize(Node node) throws Exception {
        VersionHistory versionHistory = node.getVersionHistory();
        return versionHistory.getAllVersions().getSize() - 1L;
    }

    @Override
    public List<T> getVersionList(String path) throws Exception {
        return this.getVersionList(this.session.getRootNode().getNode(this.relativePath(path)), "*", -1);
    }

    @Override
    public List<T> getVersionList(String path, String childNameFilter, int maxDepth) throws Exception {
        return this.getVersionList(this.session.getRootNode().getNode(this.relativePath(path)), childNameFilter, maxDepth);
    }

    @Override
    public List<T> getVersionList(String path, String childNameFilter, int maxDepth, long startIndex, long resultSize) throws Exception {
        return this.getVersionList(this.session.getRootNode().getNode(this.relativePath(path)), childNameFilter, maxDepth, startIndex, resultSize);
    }

    @Override
    public List<T> getVersionListByUUID(String uuid) throws Exception {
        return this.getVersionList(this.session.getNodeByUUID(uuid), "*", -1);
    }

    @Override
    public List<T> getVersionListByUUID(String uuid, String childNameFilter, int maxDepth) throws Exception {
        return this.getVersionList(this.session.getNodeByUUID(uuid), childNameFilter, maxDepth);
    }

    @Override
    public List<T> getVersionListByUUID(String uuid, String childNameFilter, int maxDepth, long startIndex, long resultSize) throws Exception {
        return this.getVersionList(this.session.getNodeByUUID(uuid), childNameFilter, maxDepth, startIndex, resultSize);
    }

    protected List<T> getVersionList(Node node, String childNameFilter, int maxDepth) throws Exception {
        ArrayList<T> versionList = new ArrayList<T>();
        VersionHistory versionHistory = node.getVersionHistory();
        VersionIterator versionIterator = versionHistory.getAllVersions();
        versionIterator.skip(1L);
        while (versionIterator.hasNext()) {
            Version version = versionIterator.nextVersion();
            NodeIterator nodeIterator = version.getNodes();
            while (nodeIterator.hasNext()) {
                T entityVersion = this.jcrom.fromNode(this.entityClass, nodeIterator.nextNode(), childNameFilter, maxDepth);
                this.jcrom.setBaseVersionInfo(entityVersion, node.getBaseVersion().getName(), node.getBaseVersion().getCreated());
                versionList.add(entityVersion);
            }
        }
        return versionList;
    }

    protected List<T> getVersionList(Node node, String childNameFilter, int maxDepth, long startIndex, long resultSize) throws Exception {
        ArrayList<T> versionList = new ArrayList<T>();
        VersionHistory versionHistory = node.getVersionHistory();
        VersionIterator versionIterator = versionHistory.getAllVersions();
        versionIterator.skip(1L + startIndex);
        for (long counter = 0L; versionIterator.hasNext() && counter != resultSize; ++counter) {
            Version version = versionIterator.nextVersion();
            NodeIterator nodeIterator = version.getNodes();
            while (nodeIterator.hasNext()) {
                versionList.add(this.jcrom.fromNode(this.entityClass, nodeIterator.nextNode(), childNameFilter, maxDepth));
            }
        }
        return versionList;
    }

    @Override
    public long getSize(String rootPath) throws Exception {
        NodeIterator nodeIterator = this.session.getRootNode().getNode(this.relativePath(rootPath)).getNodes();
        return nodeIterator.getSize();
    }

    @Override
    public List<T> findAll(String rootPath) throws Exception {
        return this.findAll(rootPath, "*", -1);
    }

    @Override
    public List<T> findAll(String rootPath, long startIndex, long resultSize) throws Exception {
        return this.findAll(rootPath, "*", -1, startIndex, resultSize);
    }

    @Override
    public List<T> findAll(String rootPath, String childNameFilter, int maxDepth) throws Exception {
        return this.toList(this.session.getRootNode().getNode(this.relativePath(rootPath)).getNodes(), childNameFilter, maxDepth);
    }

    @Override
    public List<T> findAll(String rootPath, String childNameFilter, int maxDepth, long startIndex, long resultSize) throws Exception {
        NodeIterator nodeIterator = this.session.getRootNode().getNode(this.relativePath(rootPath)).getNodes();
        nodeIterator.skip(startIndex);
        return this.toList(nodeIterator, childNameFilter, maxDepth, resultSize);
    }

    protected List<T> findByXPath(String xpath, String childNameFilter, int maxDepth, long startIndex, long resultSize) throws Exception {
        QueryManager queryManager = this.session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(xpath, "xpath");
        QueryResult result = query.execute();
        NodeIterator nodeIterator = result.getNodes();
        nodeIterator.skip(startIndex);
        return this.toList(nodeIterator, childNameFilter, maxDepth, resultSize);
    }

    protected List<T> findByXPath(String xpath, String childNameFilter, int maxDepth) throws Exception {
        QueryManager queryManager = this.session.getWorkspace().getQueryManager();
        Query query = queryManager.createQuery(xpath, "xpath");
        QueryResult result = query.execute();
        return this.toList(result.getNodes(), childNameFilter, maxDepth);
    }

    protected List<T> toList(NodeIterator nodeIterator, String childNameFilter, int maxDepth) throws Exception {
        ArrayList<T> objects = new ArrayList<T>();
        while (nodeIterator.hasNext()) {
            objects.add(this.jcrom.fromNode(this.entityClass, nodeIterator.nextNode(), childNameFilter, maxDepth));
        }
        return objects;
    }

    protected List<T> toList(NodeIterator nodeIterator, String childNameFilter, int maxDepth, long resultSize) throws Exception {
        ArrayList<T> objects = new ArrayList<T>();
        for (long counter = 0L; nodeIterator.hasNext() && counter != resultSize; ++counter) {
            objects.add(this.jcrom.fromNode(this.entityClass, nodeIterator.nextNode(), childNameFilter, maxDepth));
        }
        return objects;
    }
}

