/*
 * Decompiled with CFR 0.152.
 */
package com.totsp.xml.syndication.itunes;

import com.totsp.xml.syndication.itunes.AbstractITunesObject;
import com.totsp.xml.syndication.itunes.FeedInformation;
import com.totsp.xml.syndication.itunes.types.Category;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;

public class FeedInformationImpl
extends AbstractITunesObject
implements FeedInformation {
    private String ownerName;
    private String ownerEmailAddress;
    private URL image;

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    public String getOwnerEmailAddress() {
        return this.ownerEmailAddress;
    }

    public void setOwnerEmailAddress(String ownerEmailAddress) {
        this.ownerEmailAddress = ownerEmailAddress;
    }

    public URL getImage() {
        return this.image;
    }

    public void setImage(URL image) {
        this.image = image;
    }

    public void copyFrom(Object obj) {
        FeedInformationImpl info = (FeedInformationImpl)obj;
        this.setBlock(info.getBlock());
        if (info.getCategory() != null) {
            this.setCategory((Category)info.getCategory().clone());
        }
        this.setExplicit(info.getExplicit());
        try {
            if (info.getImage() != null) {
                this.setImage(new URL(info.getImage().toExternalForm()));
            }
        }
        catch (MalformedURLException e) {
            Logger.getAnonymousLogger().fine("Error copying URL:" + info.getImage());
        }
        if (info.getKeywords() != null) {
            this.setKeywords((String[])info.getKeywords().clone());
        }
        this.setOwnerEmailAddress(info.getOwnerEmailAddress());
        this.setOwnerName(info.getOwnerName());
        this.setSubtitle(info.getSubtitle());
        this.setSummary(info.getSummary());
    }

    public Object clone() {
        FeedInformationImpl info = new FeedInformationImpl();
        info.copyFrom(this);
        return info;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("[");
        sb.append(" email: ");
        sb.append(this.getOwnerEmailAddress());
        sb.append(" name: ");
        sb.append(this.getOwnerName());
        sb.append(" image: ");
        sb.append(this.getImage());
        sb.append("]");
        sb.append(super.toString());
        return sb.toString();
    }
}

