/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockObtainFailedException;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.search.Startable;
import org.xcmis.search.config.IndexConfiguration;
import org.xcmis.search.config.IndexConfigurationException;
import org.xcmis.search.content.IndexModificationException;
import org.xcmis.search.lucene.index.IndexException;
import org.xcmis.search.lucene.index.IndexTransaction;
import org.xcmis.search.lucene.index.IndexTransactionException;
import org.xcmis.search.lucene.index.IndexTransactionModificationReport;
import org.xcmis.search.lucene.index.LuceneIndexDataManager;
import org.xcmis.search.lucene.index.PersistedIndex;
import org.xcmis.search.lucene.index.PersistentIndexDataKeeperFactory;
import org.xcmis.search.lucene.index.merge.IndexAggregator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalStorageIndexDataManager
implements LuceneIndexDataManager,
IndexAggregator,
Startable {
    private List<PersistedIndex> chains;
    private final PersistentIndexDataKeeperFactory indexFactory;
    private final Log log = ExoLogger.getLogger(LocalStorageIndexDataManager.class);
    private final IndexConfiguration indexConfuguration;

    public LocalStorageIndexDataManager(IndexConfiguration indexConfuguration) throws IndexException, IndexConfigurationException {
        this.indexConfuguration = indexConfuguration;
        this.indexFactory = new PersistentIndexDataKeeperFactory(indexConfuguration);
    }

    @Override
    public IndexTransactionModificationReport aggregate(Collection<LuceneIndexDataManager> indexes) throws IndexException, IndexTransactionException {
        if (this.chains.size() == 0) {
            this.chains.add((PersistedIndex)this.indexFactory.merge(indexes));
        } else {
            IndexWriter writer = null;
            try {
                PersistedIndex index = this.chains.get(0);
                writer = new IndexWriter(index.getDirectory(), (Analyzer)new StandardAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
                ArrayList dirs = new ArrayList();
                for (LuceneIndexDataManager luceneIndexDataManager : indexes) {
                    luceneIndexDataManager.getIndexReader();
                    dirs.add(luceneIndexDataManager.getDirectory());
                }
                Directory[] dirsToMerge = new Directory[dirs.size()];
                writer.addIndexesNoOptimize(dirs.toArray(dirsToMerge));
                writer.optimize();
            }
            catch (CorruptIndexException e) {
                throw new IndexException(e.getLocalizedMessage(), e);
            }
            catch (LockObtainFailedException e) {
                throw new IndexException(e.getLocalizedMessage(), e);
            }
            catch (IOException e) {
                throw new IndexException(e.getLocalizedMessage(), e);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (CorruptIndexException e) {
                        throw new IndexException(e.getLocalizedMessage(), e);
                    }
                    catch (IOException e) {
                        throw new IndexException(e.getLocalizedMessage(), e);
                    }
                }
            }
        }
        return null;
    }

    @Override
    public Directory getDirectory() throws IndexException {
        if (this.chains.size() != 0) {
            return this.chains.get(0).getDirectory();
        }
        return null;
    }

    @Override
    public long getDirectorySize(boolean includeInherited) {
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Document getDocument(String uuid) throws IndexException {
        Document doc = null;
        List<PersistedIndex> list = this.chains;
        synchronized (list) {
            for (int i = 0; i < this.chains.size() && (doc = this.chains.get(i).getDocument(uuid)) == null; ++i) {
            }
        }
        return doc;
    }

    @Override
    public synchronized long getDocumentCount() {
        long result = 0L;
        for (PersistedIndex index : this.chains) {
            result += index.getDocumentCount();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexReader getIndexReader() throws IndexException {
        IndexReader result = null;
        if (this.chains.size() > 0) {
            List<PersistedIndex> list = this.chains;
            synchronized (list) {
                if (this.chains.size() > 0) {
                    ArrayList<IndexReader> readers = new ArrayList<IndexReader>(this.chains.size());
                    for (LuceneIndexDataManager luceneIndexDataManager : this.chains) {
                        IndexReader indexReader = (IndexReader)luceneIndexDataManager.getIndexReader();
                        if (indexReader == null) continue;
                        readers.add(indexReader);
                    }
                    if (result != null) {
                        readers.add(result);
                    }
                    if (readers.size() > 1) {
                        IndexReader[] indexReaderArray = new IndexReader[readers.size()];
                        result = new MultiReader(readers.toArray(indexReaderArray));
                    } else if (readers.size() == 1) {
                        result = (IndexReader)readers.get(0);
                    } else {
                        throw new RuntimeException("No readers found");
                    }
                }
            }
            if (result == null) {
                throw new RuntimeException("No readers found");
            }
        }
        return result;
    }

    @Override
    public long getLastModifedTime() {
        return 0L;
    }

    @Override
    public boolean isStarted() {
        return false;
    }

    @Override
    public boolean isStoped() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexTransactionModificationReport save(IndexTransaction<Document> changes) throws IndexException, IndexTransactionException {
        List<PersistedIndex> list = this.chains;
        synchronized (list) {
            if (changes.hasModifacationsDocuments() && (changes = this.processModifed(changes)).getRemovedDocuments().size() > 0) {
                throw new IndexModificationException("Unable to remove item's with id's " + changes.getRemovedDocuments() + " from index");
            }
            this.processAdded(changes);
        }
        return null;
    }

    @Override
    public void start() {
        try {
            this.chains = this.indexFactory.init();
        }
        catch (IndexException e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void stop() {
        for (PersistedIndex index : this.chains) {
            try {
                index.getDirectory().close();
            }
            catch (IndexException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAdded(IndexTransaction<Document> changes) throws IndexException, IndexTransactionException {
        if (changes.getAddedDocuments().size() > 0) {
            List<PersistedIndex> list = this.chains;
            synchronized (list) {
                if (this.chains.size() == 0) {
                    LuceneIndexDataManager indexDataKeeper = this.indexFactory.createNewIndexDataKeeper(changes);
                    indexDataKeeper.start();
                    this.chains.add((PersistedIndex)indexDataKeeper);
                } else {
                    LuceneIndexDataManager indexDataKeeper = this.chains.get(0);
                    indexDataKeeper.save(changes);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IndexTransaction<Document> processModifed(IndexTransaction<Document> changes) throws IndexException, IndexTransactionException {
        List<PersistedIndex> list = this.chains;
        synchronized (list) {
            Iterator<PersistedIndex> it = this.chains.iterator();
            while (it.hasNext()) {
                LuceneIndexDataManager chain = it.next();
                IndexTransactionModificationReport report = chain.save(changes);
                if (report.isModifed()) {
                    changes = changes.apply(report);
                    if (chain.getDocumentCount() == 0L) {
                        this.indexFactory.dispose(chain);
                        it.remove();
                    }
                }
                if (changes.hasModifacationsDocuments()) continue;
                break;
            }
        }
        return changes;
    }
}

