/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.social.webui.activity.UIActivityFactory;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIPopupWindow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/UIActivitiesContainer.gtmpl")
public class UIActivitiesContainer
extends UIContainer {
    private static final Log LOG = ExoLogger.getLogger(UIActivitiesContainer.class);
    private List<Activity> activityList;
    private UIComposer.PostContext postContext;
    private Space space;
    private String ownerName;
    private UIPopupWindow popupWindow;

    public UIActivitiesContainer() {
        try {
            this.popupWindow = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "OptionPopupWindow");
            this.popupWindow.setShow(false);
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    public UIPopupWindow getPopupWindow() {
        return this.popupWindow;
    }

    public UIActivitiesContainer setActivityList(List<Activity> activityList) throws Exception {
        this.activityList = activityList;
        this.init();
        return this;
    }

    public void setPostContext(UIComposer.PostContext postContext) {
        this.postContext = postContext;
    }

    public UIComposer.PostContext getPostContext() {
        return this.postContext;
    }

    public Space getSpace() {
        return this.space;
    }

    public void setSpace(Space space) {
        this.space = space;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public void setOwnerName(String ownerName) {
        this.ownerName = ownerName;
    }

    private void init() throws Exception {
        while (this.getChild(BaseUIActivity.class) != null) {
            this.removeChild(BaseUIActivity.class);
        }
        if (this.activityList == null) {
            this.activityList = new ArrayList<Activity>();
        }
        PortalContainer portalContainer = PortalContainer.getInstance();
        UIActivityFactory factory = (UIActivityFactory)((Object)portalContainer.getComponentInstanceOfType(UIActivityFactory.class));
        for (Activity activity : this.activityList) {
            factory.addChild(activity, this);
        }
    }
}

