/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.activity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.activity.model.Util;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.activity.SpaceActivityListAccess;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserActivityListAccess
implements ListAccess<Activity> {
    private static final Log LOG = ExoLogger.getLogger(SpaceActivityListAccess.class);
    private Identity ownerIdentity;
    private UIUserActivitiesDisplay.DisplayMode displayMode;
    private IdentityManager identityManager = (IdentityManager)PortalContainer.getComponent(IdentityManager.class);
    private ActivityManager activityManager = (ActivityManager)PortalContainer.getComponent(ActivityManager.class);
    private SpaceService spaceService = (SpaceService)PortalContainer.getComponent(SpaceService.class);

    public UserActivityListAccess(Identity ownerIdentity, UIUserActivitiesDisplay.DisplayMode displayMode) {
        this.ownerIdentity = ownerIdentity;
        this.displayMode = displayMode;
    }

    public int getSize() throws Exception {
        int size = this.displayMode == UIUserActivitiesDisplay.DisplayMode.MY_STATUS || this.displayMode == UIUserActivitiesDisplay.DisplayMode.OWNER_STATUS ? this.activityManager.getActivitiesCount(this.ownerIdentity) : (this.displayMode == UIUserActivitiesDisplay.DisplayMode.SPACES ? this.getActivitiesOfUserSpaces().length : this.getActivitiesOfConnections().length);
        return size;
    }

    public Activity[] load(int index, int length) throws Exception {
        List<Activity> activityList = this.displayMode == UIUserActivitiesDisplay.DisplayMode.MY_STATUS || this.displayMode == UIUserActivitiesDisplay.DisplayMode.OWNER_STATUS ? this.activityManager.getActivities(this.ownerIdentity, (long)index, (long)length) : (this.displayMode == UIUserActivitiesDisplay.DisplayMode.SPACES ? this.getActivitiesOfUserSpaces(index, length) : this.getActivitiesOfConnections(index, length));
        return activityList.toArray(new Activity[activityList.size()]);
    }

    private Object[] getActivitiesOfConnections() throws Exception {
        List<Identity> connectionsList = this.getConnections();
        TreeSet<Activity> sortedActivityList = new TreeSet<Activity>(Util.activityComparator());
        for (Identity identity : connectionsList) {
            List tempActivityList = this.activityManager.getActivities(identity);
            String identityId = identity.getId();
            for (Activity activity : tempActivityList) {
                if (!activity.getUserId().equals(identityId)) continue;
                sortedActivityList.add(activity);
            }
        }
        return sortedActivityList.toArray();
    }

    private List<Activity> getActivitiesOfConnections(int index, int length) throws Exception {
        Object[] activityArray = this.getActivitiesOfConnections();
        activityArray = ArrayUtils.subarray((Object[])activityArray, (int)index, (int)(index + length));
        ArrayList<Activity> activityList = new ArrayList<Activity>();
        for (Object obj : activityArray) {
            activityList.add((Activity)obj);
        }
        return activityList;
    }

    private Object[] getActivitiesOfUserSpaces() {
        TreeSet sortedActivityList = new TreeSet(Util.activityComparator());
        try {
            List spaceList = this.spaceService.getAccessibleSpaces(this.ownerIdentity.getRemoteId());
            for (Space space : spaceList) {
                Identity spaceIdentity = this.identityManager.getOrCreateIdentity("space", space.getId());
                List spaceActivityList = this.activityManager.getActivities(spaceIdentity);
                sortedActivityList.addAll(spaceActivityList);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
        return sortedActivityList.toArray();
    }

    private List<Activity> getActivitiesOfUserSpaces(int index, int length) {
        Object[] activityArray = this.getActivitiesOfUserSpaces();
        Object[] resultArray = ArrayUtils.subarray((Object[])activityArray, (int)index, (int)(index + length));
        ArrayList<Activity> activityList = new ArrayList<Activity>();
        for (int i = 0; i < resultArray.length; ++i) {
            Object o = resultArray[i];
            activityList.add((Activity)o);
        }
        return activityList;
    }

    private List<Identity> getConnections() throws Exception {
        List connectionsList = this.identityManager.getIdentities("organization");
        Iterator itr = connectionsList.iterator();
        while (itr.hasNext()) {
            Identity identity = (Identity)itr.next();
            if (this.getConnectionStatus(identity) == Relationship.Type.CONFIRM) continue;
            itr.remove();
        }
        return connectionsList;
    }

    private Relationship.Type getConnectionStatus(Identity identity) throws Exception {
        if (identity.getId().equals(this.ownerIdentity.getId())) {
            return Relationship.Type.SELF;
        }
        RelationshipManager relationshipManager = (RelationshipManager)PortalContainer.getComponent(RelationshipManager.class);
        Relationship relationship = relationshipManager.getRelationship(identity, this.ownerIdentity);
        return relationshipManager.getRelationshipStatus(relationship, this.ownerIdentity);
    }
}

