/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.lock;

import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.jboss.cache.Fqn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class StripedLock {
    private static final int DEFAULT_CONCURRENCY = 20;
    private final int lockSegmentMask;
    private final int lockSegmentShift;
    final ReentrantReadWriteLock[] sharedLocks;

    public StripedLock() {
        this(20);
    }

    public StripedLock(int concurrency) {
        int numLocks;
        int tempLockSegShift = 0;
        for (numLocks = 1; numLocks < concurrency; numLocks <<= 1) {
            ++tempLockSegShift;
        }
        this.lockSegmentShift = 32 - tempLockSegShift;
        this.lockSegmentMask = numLocks - 1;
        this.sharedLocks = new ReentrantReadWriteLock[numLocks];
        for (int i = 0; i < numLocks; ++i) {
            this.sharedLocks[i] = new ReentrantReadWriteLock();
        }
    }

    public void acquireLock(Fqn fqn, boolean exclusive) {
        ReentrantReadWriteLock lock = this.getLock(fqn);
        if (exclusive) {
            lock.writeLock().lock();
        } else {
            lock.readLock().lock();
        }
    }

    public void releaseLock(Fqn fqn) {
        ReentrantReadWriteLock lock = this.getLock(fqn);
        if (lock.isWriteLockedByCurrentThread()) {
            lock.writeLock().unlock();
        } else {
            lock.readLock().unlock();
        }
    }

    final ReentrantReadWriteLock getLock(Object o) {
        return this.sharedLocks[this.hashToIndex(o)];
    }

    final int hashToIndex(Object o) {
        return this.hash(o) >>> this.lockSegmentShift & this.lockSegmentMask;
    }

    final int hash(Object x) {
        int h = x.hashCode();
        h += h << 15 ^ 0xFFFFCD7D;
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        h ^= h >>> 16;
        return h;
    }

    public void releaseAllLocks(List<Fqn> fqns) {
        for (Fqn f : fqns) {
            this.releaseLock(f);
        }
    }

    public void acquireAllLocks(List<Fqn> fqns, boolean exclusive) {
        for (Fqn f : fqns) {
            this.acquireLock(f, exclusive);
        }
    }
}

