/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.collections;

import java.util.List;
import org.apache.abdera.i18n.iri.IRI;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.Entry;
import org.apache.abdera.model.Feed;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.context.ResponseContextException;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.collections.CmisObjectCollection;
import org.xcmis.spi.Connection;
import org.xcmis.spi.FilterNotValidException;
import org.xcmis.spi.InvalidArgumentException;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.model.CmisObject;
import org.xcmis.spi.model.IncludeRelationships;
import org.xcmis.spi.model.ObjectParent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentsCollection
extends CmisObjectCollection {
    public ParentsCollection() {
        this.setHref("/parents");
    }

    public Iterable<CmisObject> getEntries(RequestContext request) throws ResponseContextException {
        throw new UnsupportedOperationException("entries");
    }

    public String getTitle(RequestContext request) {
        return "Object Parents";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void addFeedDetails(Feed feed, RequestContext request) throws ResponseContextException {
        IncludeRelationships includeRelationships;
        boolean includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions", false);
        boolean includeRelativePathSegment = this.getBooleanParameter(request, "includeRelativePathSegment", false);
        String propertyFilter = request.getParameter("filter");
        String renditionFilter = request.getParameter("renditionFilter");
        try {
            includeRelationships = request.getParameter("includeRelationships") == null || request.getParameter("includeRelationships").length() == 0 ? IncludeRelationships.NONE : IncludeRelationships.fromValue((String)request.getParameter("includeRelationships"));
        }
        catch (IllegalArgumentException iae) {
            String msg = "Invalid parameter " + request.getParameter("includeRelationships");
            throw new ResponseContextException(msg, 400);
        }
        Connection conn = null;
        try {
            conn = this.getConnection(request);
            String objectId = this.getId(request);
            CmisObject object = conn.getObject(objectId, false, IncludeRelationships.NONE, false, false, true, "cmis:baseTypeId", null);
            switch (this.getBaseObjectType(object)) {
                case FOLDER: {
                    CmisObject folderParent = conn.getFolderParent(objectId, true, propertyFilter);
                    if (folderParent == null) return;
                    Element numItems = feed.addExtension(AtomCMIS.NUM_ITEMS);
                    numItems.setText("1");
                    Entry e = feed.addEntry();
                    IRI feedIri = new IRI(this.getFeedIriForEntry(folderParent, request));
                    this.addEntryDetails(request, e, feedIri, folderParent);
                    String name = object.getObjectInfo().getName();
                    if (name == null) return;
                    Element pathSegment = e.addExtension(AtomCMIS.RELATIVE_PATH_SEGMENT);
                    pathSegment.setText(name);
                    return;
                }
                default: {
                    List parents = conn.getObjectParents(objectId, includeAllowableActions, includeRelationships, includeRelativePathSegment, true, propertyFilter, renditionFilter);
                    if (parents.size() <= 0) return;
                    Element numItems = feed.addExtension(AtomCMIS.NUM_ITEMS);
                    numItems.setText(Integer.toString(parents.size()));
                    for (ObjectParent parent : parents) {
                        Entry e = feed.addEntry();
                        IRI feedIri = new IRI(this.getFeedIriForEntry(parent.getObject(), request));
                        this.addEntryDetails(request, e, feedIri, parent.getObject());
                        if (parent.getRelativePathSegment() == null) continue;
                        Element pathSegment = e.addExtension(AtomCMIS.RELATIVE_PATH_SEGMENT);
                        pathSegment.setText(parent.getRelativePathSegment());
                    }
                    return;
                }
            }
        }
        catch (FilterNotValidException fe) {
            throw new ResponseContextException(this.createErrorResponse(fe, 500));
        }
        catch (ObjectNotFoundException onfe) {
            throw new ResponseContextException(this.createErrorResponse(onfe, 404));
        }
        catch (InvalidArgumentException iae) {
            throw new ResponseContextException(this.createErrorResponse(iae, 400));
        }
        catch (Throwable t) {
            throw new ResponseContextException(this.createErrorResponse(t, 500));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }
}

