/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.webui.portal.UIPortal;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.SpaceUtils;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="classpath:groovy/social/webui/space/UISpaceMenu.gtmpl", events={@EventConfig(name="RenameSpaceAppName", listeners={RenameSpaceAppNameActionListener.class})})
public class UISpaceMenu
extends UIContainer {
    private static final String NEW_SPACE_APPLICATION_NAME = "newSpaceAppName";
    private static final String INVALID_APPLICATION_NAME_MSG = "UISpaceMenuPortlet.msg.invalidAppName";
    private static final String EXISTING_APPLICATION_NAME_MSG = "UISpaceMenuPortlet.msg.existingAppName";
    private static final String SPACE_SETTING_PORTLET = "SpaceSettingPortlet";
    private SpaceService spaceService = null;
    private Space space = null;

    public List<PageNode> getApps() throws Exception {
        String spaceUrl = SpaceUtils.getSpaceUrl();
        SpaceService spaceSrc = (SpaceService)this.getApplicationComponent(SpaceService.class);
        this.space = spaceSrc.getSpaceByUrl(spaceUrl);
        if (this.space == null) {
            return new ArrayList<PageNode>(0);
        }
        DataStorage dataStorage = (DataStorage)this.getApplicationComponent(DataStorage.class);
        PageNavigation pageNav = dataStorage.getPageNavigation("group", this.space.getGroupId());
        PageNode homeNode = SpaceUtils.getHomeNode((PageNavigation)pageNav, (String)this.space.getUrl());
        if (homeNode == null) {
            throw new Exception("homeNode is null!");
        }
        List list = homeNode.getNodes();
        PageNode pageNode = null;
        for (PageNode node : list) {
            if (!node.getName().contains(SPACE_SETTING_PORTLET)) continue;
            pageNode = node;
            break;
        }
        if (!this.isLeader() && pageNode != null) {
            list.remove(pageNode);
        }
        Collections.sort(list, new ApplicationComparator());
        return list;
    }

    public String getSpaceName() throws Exception {
        this.space = this.getSpace();
        if (this.space == null) {
            return null;
        }
        return this.space.getName();
    }

    public String getAppSelected() throws Exception {
        UIPortal uiPortal = Util.getUIPortal();
        PageNode selectedNode = uiPortal.getSelectedNode();
        String[] split = selectedNode.getUri().split("/");
        return split[split.length - 1];
    }

    protected String getImageSource() throws Exception {
        Space space = this.getSpace();
        if (space != null) {
            return space.getImageSource();
        }
        return "";
    }

    private boolean isLeader() throws SpaceException {
        this.spaceService = this.getSpaceService();
        String userId = Util.getPortalRequestContext().getRemoteUser();
        Space space = this.getSpace();
        return this.spaceService.hasEditPermission(space.getId(), userId);
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private Space getSpace() {
        if (this.space == null) {
            try {
                this.spaceService = this.getSpaceService();
                String spaceUrl = SpaceUtils.getSpaceUrl();
                this.space = this.spaceService.getSpaceByUrl(spaceUrl);
            }
            catch (SpaceException e) {
                e.printStackTrace();
            }
        }
        return this.space;
    }

    private boolean isAppNameExisted(PageNavigation pageNav, String nodeName) throws Exception {
        PageNode homeNode = pageNav.getNode(SpaceUtils.getSpaceUrl());
        if (homeNode == null) {
            throw new Exception("homeNode is null!");
        }
        List nodes = homeNode.getChildren();
        for (PageNode node : pageNav.getNodes()) {
            if (!node.getName().equals(nodeName)) continue;
            return true;
        }
        for (PageNode node : nodes) {
            if (!node.getName().equals(nodeName)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidAppName(String appName) {
        if ((appName = appName.trim()) == null || appName.length() < 1) {
            return false;
        }
        if (Character.isDigit(appName.charAt(0)) || appName.charAt(0) == '-') {
            return false;
        }
        for (int i = 0; i < appName.length(); ++i) {
            char c = appName.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-' || Character.isSpaceChar(c)) continue;
            return false;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ApplicationComparator
    implements Comparator<PageNode> {
        private ApplicationComparator() {
        }

        @Override
        public int compare(PageNode pageNode1, PageNode pageNode2) {
            return pageNode1.getResolvedLabel().compareToIgnoreCase(pageNode2.getResolvedLabel());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RenameSpaceAppNameActionListener
    extends EventListener<UISpaceMenu> {
        public void execute(Event<UISpaceMenu> event) throws Exception {
            UISpaceMenu spaceMenu = (UISpaceMenu)((Object)event.getSource());
            WebuiRequestContext context = event.getRequestContext();
            String newSpaceAppName = context.getRequestParameter(UISpaceMenu.NEW_SPACE_APPLICATION_NAME);
            UIPortal uiPortal = Util.getUIPortal();
            PortalRequestContext prContext = Util.getPortalRequestContext();
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            DataStorage dataStorage = (DataStorage)container.getComponentInstanceOfType(DataStorage.class);
            SpaceService spaceService = (SpaceService)spaceMenu.getApplicationComponent(SpaceService.class);
            String spaceUrl = SpaceUtils.getSpaceUrl();
            Space space = spaceService.getSpaceByUrl(spaceUrl);
            PageNode selectedNode = uiPortal.getSelectedNode();
            PageNode homeNode = null;
            UIPortalApplication uiPortalApp = Util.getUIPortalApplication();
            UserPortalConfig userPortalConfig = uiPortalApp.getUserPortalConfig();
            List navigations = userPortalConfig.getNavigations();
            PageNavigation spaceNavigation = SpaceUtils.getGroupNavigation((String)space.getGroupId());
            for (PageNavigation navi : navigations) {
                if (!navi.getOwner().equals(spaceNavigation.getOwner())) continue;
                spaceNavigation = navi;
                break;
            }
            if ((homeNode = SpaceUtils.getHomeNode((PageNavigation)spaceNavigation, (String)spaceUrl)) == null) {
                throw new Exception("homeNode is null!");
            }
            List childNodes = homeNode.getNodes();
            String oldName = selectedNode.getName();
            String oldUri = selectedNode.getUri();
            if (selectedNode.getResolvedLabel().equals(newSpaceAppName)) {
                prContext.getResponse().sendRedirect(prContext.getPortalURI() + oldUri);
                return;
            }
            UIApplication uiApp = context.getUIApplication();
            if (!spaceMenu.isValidAppName(newSpaceAppName)) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMenu.INVALID_APPLICATION_NAME_MSG, null, 1));
                prContext.getResponse().sendRedirect(prContext.getPortalURI() + oldUri);
                return;
            }
            String newNodeName = newSpaceAppName.trim().replace(' ', '_');
            if (spaceMenu.isAppNameExisted(spaceNavigation, newNodeName)) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMenu.EXISTING_APPLICATION_NAME_MSG, null, 2));
                prContext.getResponse().sendRedirect(prContext.getPortalURI() + oldUri);
                return;
            }
            String newUri = oldUri.substring(0, oldUri.lastIndexOf("/") + 1) + newNodeName;
            PageNode childNode = null;
            for (int i = 0; i < childNodes.size(); ++i) {
                childNode = (PageNode)childNodes.get(i);
                if (!selectedNode.getName().equals(childNode.getName())) continue;
                childNode.setLabel(newSpaceAppName);
                childNode.setName(newNodeName);
                childNode.setUri(newUri);
                selectedNode = childNode;
                break;
            }
            String installedApps = space.getApp();
            String[] apps = installedApps.split(",");
            String[] appParts = null;
            String editedApp = null;
            String newInstalledApps = null;
            for (String app : apps) {
                if (app.length() == 0 || !(appParts = app.split(":"))[1].equals(oldName)) continue;
                editedApp = appParts[0] + ":" + newNodeName + ":" + appParts[2] + ":" + appParts[3];
                newInstalledApps = installedApps.replaceAll(app, editedApp);
                space.setApp(newInstalledApps);
                spaceService.saveSpace(space, false);
                break;
            }
            dataStorage.save(spaceNavigation);
            uiPortal.setSelectedNode(selectedNode);
            uiPortal.setSelectedNavigation(spaceNavigation);
            SpaceUtils.setNavigation((PageNavigation)spaceNavigation);
            if (newUri != null) {
                prContext.getResponse().sendRedirect(prContext.getPortalURI() + newUri);
            }
        }
    }
}

