/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.plugins.webui;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Locale;
import javax.jcr.Node;
import org.exoplatform.download.DownloadResource;
import org.exoplatform.download.DownloadService;
import org.exoplatform.download.InputStreamDownloadResource;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wcm.webui.reader.ContentReader;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="classpath:resources/templates/staticdirect/publication.gtmpl")
public class UIPublicationComponent
extends UIComponent {
    private Node node_;
    private static final Log LOG = ExoLogger.getLogger((String)"component.UIPublicationComponent");

    public UIPublicationComponent() throws Exception {
    }

    public UIPublicationComponent(Node node) throws Exception {
        this.node_ = node;
    }

    public Node getNode() {
        return this.node_;
    }

    public void setNode(Node node) {
        this.node_ = node;
    }

    public String getNodeName() {
        try {
            return ContentReader.getXSSCompatibilityContent((String)this.node_.getName());
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return "Error in getNodeName";
        }
    }

    public String getLifeCycleName() {
        try {
            PublicationService service = (PublicationService)this.getApplicationComponent(PublicationService.class);
            return service.getNodeLifecycleName(this.node_);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return "Error in getLifeCycleName";
        }
    }

    public String getStateName() {
        try {
            PublicationService service = (PublicationService)this.getApplicationComponent(PublicationService.class);
            return service.getCurrentState(this.node_);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return "Error in getStateName";
        }
    }

    public String getLinkStateImage(Locale locale) {
        try {
            DownloadService dS = (DownloadService)this.getApplicationComponent(DownloadService.class);
            PublicationService service = (PublicationService)this.getApplicationComponent(PublicationService.class);
            byte[] bytes = service.getStateImage(this.node_, locale);
            ByteArrayInputStream iS = new ByteArrayInputStream(bytes);
            String id = dS.addDownloadResource((DownloadResource)new InputStreamDownloadResource((InputStream)iS, "image/gif"));
            return dS.getDownloadLink(id);
        }
        catch (Exception e) {
            LOG.error((Object)"Unexpected error", (Throwable)e);
            return "Error in getStateImage";
        }
    }
}

