/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.explorer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesBrowser;
import org.exoplatform.ecm.webui.component.explorer.UIDrivesBrowserContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/explorer/UIRepositoryList.gtmpl", events={@EventConfig(listeners={ChangeRepoActionListener.class})})
public class UIRepositoryList
extends UIForm {
    public static String FIELD_SELECTREPO = "selectRepo";
    private String repoName_;
    private RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);

    public UIRepositoryList() throws Exception {
        this.repoName_ = this.rService.getDefaultRepository().getConfiguration().getName();
    }

    public String getRepository() {
        return this.repoName_;
    }

    public void setRepository(String repoName) {
        this.repoName_ = repoName;
    }

    public void initRepoList(String defaultRepo) throws Exception {
        UIFormSelectBox uiFormSelectBox = (UIFormSelectBox)this.getChild(UIFormSelectBox.class);
        String selectedValue = defaultRepo;
        if (uiFormSelectBox == null) {
            uiFormSelectBox = new UIFormSelectBox(FIELD_SELECTREPO, FIELD_SELECTREPO, null);
            this.addUIFormInput((UIFormInput)uiFormSelectBox);
        } else {
            selectedValue = (String)uiFormSelectBox.getValue();
        }
        uiFormSelectBox.setOptions(this.getRepoItem());
        uiFormSelectBox.setOnChange("ChangeRepo");
        uiFormSelectBox.setValue(selectedValue);
    }

    private List<SelectItemOption<String>> getRepoItem() {
        ArrayList<SelectItemOption<String>> options = new ArrayList<SelectItemOption<String>>();
        Iterator i$ = this.rService.getConfig().getRepositoryConfigurations().iterator();
        while (i$.hasNext()) {
            RepositoryEntry obj;
            RepositoryEntry repo = obj = (RepositoryEntry)i$.next();
            options.add((SelectItemOption<String>)new SelectItemOption(repo.getName(), (Object)repo.getName()));
        }
        return options;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeRepoActionListener
    extends EventListener<UIRepositoryList> {
        public void execute(Event<UIRepositoryList> event) throws Exception {
            UIRepositoryList uiRepositoryList = (UIRepositoryList)((Object)event.getSource());
            UIDrivesBrowserContainer uiDrivesBrowserContainer = (UIDrivesBrowserContainer)uiRepositoryList.getParent();
            UIDrivesBrowser uiDrivesBrowser = (UIDrivesBrowser)uiDrivesBrowserContainer.getChild(UIDrivesBrowser.class);
            UIFormSelectBox uiFormSelectBox = uiRepositoryList.getUIFormSelectBox(FIELD_SELECTREPO);
            String repoName = (String)uiFormSelectBox.getValue();
            uiFormSelectBox.setValue(repoName);
            uiDrivesBrowser.setRepository(repoName);
            uiRepositoryList.setRepository(repoName);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiDrivesBrowserContainer);
        }
    }
}

