/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.download;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.ws.rs.core.StreamingOutput;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.exoplatform.ide.download.Const;
import org.exoplatform.ide.download.NodeTypeUtil;

public class DirectoryContentEntity
implements StreamingOutput,
Const {
    private String pathPrefix;
    private Node nodeToPack;

    public DirectoryContentEntity(Node nodeToPack) {
        this.nodeToPack = nodeToPack;
    }

    public void write(OutputStream outputStream) throws IOException {
        ZipArchiveOutputStream zipOut = new ZipArchiveOutputStream(outputStream);
        zipOut.setEncoding("UTF-8");
        try {
            this.pathPrefix = this.nodeToPack.getPath();
            this.pathPrefix = this.pathPrefix.substring(0, this.pathPrefix.length() - this.nodeToPack.getName().length());
            this.zipNodeContent(this.nodeToPack, zipOut);
        }
        catch (RepositoryException exc) {
            throw new IOException(exc.getMessage());
        }
        zipOut.close();
    }

    private void zipNodeContent(Node node, ZipArchiveOutputStream zipOutputStream) throws RepositoryException, IOException {
        String path = node.getPath();
        path = path.substring(this.pathPrefix.length());
        if (NodeTypeUtil.isFile(node)) {
            InputStream inputStream = node.getNode("jcr:content").getProperty("jcr:data").getStream();
            ZipArchiveEntry zipEntry = new ZipArchiveEntry(path);
            zipOutputStream.putArchiveEntry((ArchiveEntry)zipEntry);
            this.flushJCRData(inputStream, zipOutputStream);
            zipOutputStream.closeArchiveEntry();
        } else {
            if (!"/".equals(node.getPath())) {
                path = path + "/";
                ZipArchiveEntry zipEntry = new ZipArchiveEntry(path);
                zipOutputStream.putArchiveEntry((ArchiveEntry)zipEntry);
                zipOutputStream.closeArchiveEntry();
            }
            NodeIterator nodeIterator = node.getNodes();
            while (nodeIterator.hasNext()) {
                Node child = nodeIterator.nextNode();
                this.zipNodeContent(child, zipOutputStream);
            }
        }
    }

    private void flushJCRData(InputStream inputStream, ZipArchiveOutputStream zipOutputStream) throws IOException {
        int readed;
        byte[] buffer = new byte[4096];
        while ((readed = inputStream.read(buffer)) >= 0) {
            zipOutputStream.write(buffer, 0, readed);
        }
    }
}

