/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.content;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.Validate;
import org.xcmis.search.value.PropertyType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property<V> {
    private final PropertyType type;
    private final String name;
    private final Collection<ContentValue<V>> value;

    public Property(PropertyType type, String name, Collection<ContentValue<V>> value) {
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public String toString() {
        return this.name + "=" + this.value.toString();
    }

    public Property(PropertyType type, String name, ContentValue<V> value) {
        this.type = type;
        this.name = name;
        this.value = new ArrayList<ContentValue<V>>(1);
        this.value.add(value);
    }

    public PropertyType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Collection<ContentValue<V>> getValue() {
        return this.value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BinaryValue
    extends ContentValue<InputStream> {
        private final InputStream value;
        private final String mimeType;
        private final String encoding;
        private final long length;

        public BinaryValue(InputStream value, String mimeType, String encoding, long length) {
            super(length);
            Validate.notNull((Object)value, (String)"The value argument may not be null");
            this.value = value;
            this.mimeType = mimeType;
            this.encoding = encoding;
            this.length = length;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public String getEncoding() {
            return this.encoding;
        }

        @Override
        public InputStream getValue() {
            return this.value;
        }

        @Override
        public long getLength() {
            return this.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SimpleValue<V>
    extends ContentValue<V> {
        private final V value;

        public SimpleValue(V value, long length) {
            super(length);
            this.value = value;
        }

        public SimpleValue(V value) {
            super(value.toString().length());
            this.value = value;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ContentValue<V> {
        private final long length;

        public ContentValue(long length) {
            this.length = length;
        }

        public abstract V getValue();

        public long getLength() {
            return this.length;
        }
    }
}

