/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.groovy;

import java.io.InputStream;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.exoplatform.services.jcr.ext.script.groovy.GroovyScript2RestLoader;

@Path(value="/services/groovy")
public class GroovyScriptService {
    private static final String WEBDAV_CONTEXT = "jcr";
    private GroovyScript2RestLoader groovyScript2RestLoader;

    public GroovyScriptService(GroovyScript2RestLoader groovyScript2RestLoader) {
        this.groovyScript2RestLoader = groovyScript2RestLoader;
    }

    @POST
    @Path(value="/validate")
    public Response validate(@HeaderParam(value="location") String location, InputStream inputStream) {
        try {
            return this.groovyScript2RestLoader.validateScript(location, inputStream);
        }
        catch (Throwable e) {
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }

    @POST
    @Path(value="/load")
    public Response load(@Context UriInfo uriInfo, @HeaderParam(value="location") String location, @QueryParam(value="state") String state) {
        try {
            String prefix = uriInfo.getBaseUri().toASCIIString() + "/" + WEBDAV_CONTEXT + "/";
            if (!location.startsWith(prefix)) {
                return Response.status((int)404).entity((Object)(location + " Not found!")).build();
            }
            location = location.substring(prefix.length());
            String repositoryName = location.substring(0, location.indexOf("/"));
            location = location.substring(location.indexOf("/") + 1);
            String workspaceName = location.substring(0, location.indexOf("/"));
            String path = location.substring(location.indexOf("/") + 1);
            boolean load = Boolean.parseBoolean(state);
            return this.groovyScript2RestLoader.load(repositoryName, workspaceName, path, load);
        }
        catch (Throwable e) {
            return Response.status((int)500).entity((Object)e.getMessage()).build();
        }
    }
}

