/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shindig.gadgets.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.shindig.common.uri.Uri;
import org.apache.shindig.gadgets.Gadget;
import org.apache.shindig.gadgets.parse.caja.CajaCssSanitizer;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeature;
import org.apache.shindig.gadgets.rewrite.ContentRewriterFeatureFactory;
import org.apache.shindig.gadgets.rewrite.ContentRewriterUris;
import org.apache.shindig.gadgets.rewrite.GadgetRewriter;
import org.apache.shindig.gadgets.rewrite.LinkRewriter;
import org.apache.shindig.gadgets.rewrite.MutableContent;
import org.apache.shindig.gadgets.rewrite.ProxyingLinkRewriter;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SanitizingGadgetRewriter
implements GadgetRewriter {
    private static final String BYPASS_SANITIZATION_KEY = "shindig.bypassSanitization";
    private static UserDataHandler copyOnClone = new UserDataHandler(){

        public void handle(short operation, String key, Object data, Node src, Node dst) {
            if (operation == 2 || operation == 1) {
                dst.setUserData(key, data, copyOnClone);
            }
        }
    };
    private final Set<String> allowedTags;
    private final Set<String> allowedAttributes;
    private final CajaCssSanitizer cssSanitizer;
    private final ContentRewriterFeatureFactory rewriterFeatureFactory;
    private final ContentRewriterUris rewriterUris;

    public static boolean isSanitizedRenderingRequest(Gadget gadget) {
        return "1".equals(gadget.getContext().getParameter("sanitize"));
    }

    public static void bypassSanitization(Element element, boolean includingChildren) {
        element.setUserData(BYPASS_SANITIZATION_KEY, (Object)(includingChildren ? Bypass.ALL : Bypass.ONLY_SELF), copyOnClone);
    }

    @Inject
    public SanitizingGadgetRewriter(@AllowedTags Set<String> allowedTags, @AllowedAttributes Set<String> allowedAttributes, ContentRewriterFeatureFactory rewriterFeatureFactory, ContentRewriterUris rewriterUris, CajaCssSanitizer cssSanitizer) {
        this.allowedTags = allowedTags;
        this.allowedAttributes = allowedAttributes;
        this.rewriterUris = rewriterUris;
        this.cssSanitizer = cssSanitizer;
        this.rewriterFeatureFactory = rewriterFeatureFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rewrite(Gadget gadget, MutableContent content) {
        if (gadget.sanitizeOutput()) {
            boolean sanitized = false;
            try {
                new NodeSanitizer(gadget).sanitize(content.getDocument().getDocumentElement());
                content.documentChanged();
                sanitized = true;
            }
            finally {
                if (!sanitized) {
                    content.setContent("");
                }
            }
        }
    }

    private static List<Attr> toList(NamedNodeMap nodes) {
        ArrayList<Attr> list = new ArrayList<Attr>(nodes.getLength());
        int j = nodes.getLength();
        for (int i = 0; i < j; ++i) {
            list.add((Attr)nodes.item(i));
        }
        return list;
    }

    private static List<Node> toList(NodeList nodes) {
        ArrayList<Node> list = new ArrayList<Node>(nodes.getLength());
        int j = nodes.getLength();
        for (int i = 0; i < j; ++i) {
            list.add(nodes.item(i));
        }
        return list;
    }

    private static Bypass canBypassSanitization(Element element) {
        Bypass bypass = (Bypass)((Object)element.getUserData(BYPASS_SANITIZATION_KEY));
        if (bypass == null) {
            bypass = Bypass.NONE;
        }
        return bypass;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingAnnotation
    public static @interface AllowedAttributes {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    @BindingAnnotation
    public static @interface AllowedTags {
    }

    static class SanitizingProxyingLinkRewriter
    extends ProxyingLinkRewriter {
        private final String expectedMime;

        SanitizingProxyingLinkRewriter(Uri gadgetUri, ContentRewriterFeature rewriterFeature, String prefix, String expectedMime) {
            super(gadgetUri, rewriterFeature, prefix);
            this.expectedMime = expectedMime;
        }

        public String rewrite(String link, Uri context) {
            try {
                Uri.parse((String)link);
            }
            catch (RuntimeException re) {
                return "about:blank";
            }
            String rewritten = super.rewrite(link, context);
            rewritten = rewritten + "&sanitize=1";
            rewritten = rewritten + "&rewriteMime=" + this.expectedMime;
            return rewritten;
        }
    }

    static class TargetFilter
    implements DomFilter {
        TargetFilter() {
        }

        public DomFilter.Result filterTag(Element elem, Uri context) {
            return DomFilter.Result.CONTINUE;
        }

        public DomFilter.Result filterAttribute(Attr attr, Uri context) {
            String value;
            if ("target".equalsIgnoreCase(attr.getName()) && !"_blank".equals(value = attr.getValue().toLowerCase()) && !"_self".equals(value)) {
                return DomFilter.Result.REMOVE;
            }
            return DomFilter.Result.CONTINUE;
        }
    }

    static class LinkFilter
    implements DomFilter {
        final LinkRewriter rewriter;

        LinkFilter(LinkRewriter rewriter) {
            this.rewriter = rewriter;
        }

        public DomFilter.Result filterTag(Element elem, Uri context) {
            if (!elem.getNodeName().equalsIgnoreCase("link")) {
                return DomFilter.Result.CONTINUE;
            }
            boolean hasType = false;
            for (Attr attr : SanitizingGadgetRewriter.toList(elem.getAttributes())) {
                if ("rel".equalsIgnoreCase(attr.getName())) {
                    hasType |= "stylesheet".equalsIgnoreCase(attr.getValue());
                    continue;
                }
                if ("type".equalsIgnoreCase(attr.getName())) {
                    hasType |= "text/css".equalsIgnoreCase(attr.getValue());
                    continue;
                }
                if (!"href".equalsIgnoreCase(attr.getName())) continue;
                attr.setValue(this.rewriter.rewrite(attr.getValue(), context));
            }
            return hasType ? DomFilter.Result.PASS : DomFilter.Result.REMOVE;
        }

        public DomFilter.Result filterAttribute(Attr attr, Uri context) {
            return DomFilter.Result.PASS;
        }
    }

    static class StyleFilter
    implements DomFilter {
        final CajaCssSanitizer sanitizer;
        final LinkRewriter importRewriter;
        final LinkRewriter imageRewriter;

        StyleFilter(CajaCssSanitizer sanitizer, LinkRewriter importRewriter, LinkRewriter imageRewriter) {
            this.sanitizer = sanitizer;
            this.importRewriter = importRewriter;
            this.imageRewriter = imageRewriter;
        }

        public DomFilter.Result filterTag(Element elem, Uri context) {
            if ("style".equalsIgnoreCase(elem.getNodeName())) {
                this.sanitizer.sanitize(elem, context, this.importRewriter, this.imageRewriter);
            }
            return DomFilter.Result.PASS;
        }

        public DomFilter.Result filterAttribute(Attr attr, Uri context) {
            return DomFilter.Result.PASS;
        }
    }

    static class ImageFilter
    implements DomFilter {
        protected final LinkRewriter imageRewriter;

        ImageFilter(LinkRewriter imageRewriter) {
            this.imageRewriter = imageRewriter;
        }

        public DomFilter.Result filterTag(Element elem, Uri context) {
            if ("img".equalsIgnoreCase(elem.getNodeName())) {
                return DomFilter.Result.CONTINUE;
            }
            return DomFilter.Result.PASS;
        }

        public DomFilter.Result filterAttribute(Attr attr, Uri context) {
            if ("src".equalsIgnoreCase(attr.getName())) {
                attr.setValue(this.imageRewriter.rewrite(attr.getValue(), context));
            }
            return DomFilter.Result.PASS;
        }
    }

    static class LinkSchemeCheckFilter
    implements DomFilter {
        protected Set<String> uriAttributes = ImmutableSet.of((Object[])new String[]{"href", "src"});

        LinkSchemeCheckFilter() {
        }

        public DomFilter.Result filterTag(Element elem, Uri context) {
            return DomFilter.Result.CONTINUE;
        }

        public DomFilter.Result filterAttribute(Attr attr, Uri context) {
            if (this.uriAttributes.contains(attr.getName().toLowerCase())) {
                try {
                    Uri uri = Uri.parse((String)attr.getValue());
                    String scheme = uri.getScheme();
                    if (scheme != null && !scheme.equals("http") && !scheme.equals("https")) {
                        return DomFilter.Result.REMOVE;
                    }
                }
                catch (IllegalArgumentException iae) {
                    return DomFilter.Result.REMOVE;
                }
            }
            return DomFilter.Result.CONTINUE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BasicElementFilter
    implements DomFilter {
        final Set<String> allowedTags;
        final Set<String> allowedAttrs;

        BasicElementFilter(Set<String> allowedTags, Set<String> allowedAttrs) {
            this.allowedTags = allowedTags;
            this.allowedAttrs = allowedAttrs;
        }

        @Override
        public DomFilter.Result filterTag(Element elem, Uri context) {
            return this.allowedTags.contains(elem.getNodeName().toLowerCase()) ? DomFilter.Result.CONTINUE : DomFilter.Result.REMOVE;
        }

        @Override
        public DomFilter.Result filterAttribute(Attr attr, Uri context) {
            return this.allowedAttrs.contains(attr.getName().toLowerCase()) ? DomFilter.Result.CONTINUE : DomFilter.Result.REMOVE;
        }
    }

    static interface DomFilter {
        public Result filterTag(Element var1, Uri var2);

        public Result filterAttribute(Attr var1, Uri var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Result {
            PASS,
            CONTINUE,
            REMOVE;

        }
    }

    class NodeSanitizer {
        private final Uri context;
        private final List<DomFilter> filters;

        NodeSanitizer(Gadget gadget) {
            this.context = gadget.getSpec().getUrl();
            Integer expires = SanitizingGadgetRewriter.this.rewriterFeatureFactory.getDefault(gadget.getContext().getContainer()).getExpires();
            ContentRewriterFeature rewriterFeature = SanitizingGadgetRewriter.this.rewriterFeatureFactory.createRewriteAllFeature(expires == null ? -1 : expires);
            String proxyBaseNoGadget = SanitizingGadgetRewriter.this.rewriterUris.getProxyBase(gadget.getContext().getContainer());
            SanitizingProxyingLinkRewriter cssImportRewriter = new SanitizingProxyingLinkRewriter(gadget.getSpec().getUrl(), rewriterFeature, proxyBaseNoGadget, "text/css");
            SanitizingProxyingLinkRewriter imageRewriter = new SanitizingProxyingLinkRewriter(gadget.getSpec().getUrl(), rewriterFeature, proxyBaseNoGadget, "image/*");
            this.filters = ImmutableList.of((Object[])new DomFilter[]{new BasicElementFilter(SanitizingGadgetRewriter.this.allowedTags, SanitizingGadgetRewriter.this.allowedAttributes), new LinkSchemeCheckFilter(), new StyleFilter(SanitizingGadgetRewriter.this.cssSanitizer, cssImportRewriter, imageRewriter), new LinkFilter(cssImportRewriter), new ImageFilter(imageRewriter), new TargetFilter()});
        }

        private void sanitize(Node node) {
            switch (node.getNodeType()) {
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 1: 
                case 9: {
                    Element element = (Element)node;
                    Bypass bypass = SanitizingGadgetRewriter.canBypassSanitization(element);
                    if (bypass == Bypass.ALL) {
                        return;
                    }
                    if (bypass == Bypass.ONLY_SELF) {
                        for (Node child : SanitizingGadgetRewriter.toList(node.getChildNodes())) {
                            this.sanitize(child);
                        }
                    } else {
                        boolean removed = false;
                        for (DomFilter filter : this.filters) {
                            Attr attr;
                            DomFilter.Result attrResult;
                            DomFilter.Result tagResult = filter.filterTag(element, this.context);
                            if (tagResult == DomFilter.Result.REMOVE) {
                                element.getParentNode().removeChild(element);
                                removed = true;
                                break;
                            }
                            if (tagResult != DomFilter.Result.CONTINUE) continue;
                            Iterator i$ = SanitizingGadgetRewriter.toList(node.getAttributes()).iterator();
                            while (i$.hasNext() && (attrResult = filter.filterAttribute(attr = (Attr)i$.next(), this.context)) != DomFilter.Result.PASS) {
                                if (attrResult != DomFilter.Result.REMOVE) continue;
                                element.removeAttributeNode(attr);
                            }
                        }
                        if (removed) break;
                        for (Node child : SanitizingGadgetRewriter.toList(node.getChildNodes())) {
                            this.sanitize(child);
                        }
                    }
                    break;
                }
                default: {
                    node.getParentNode().removeChild(node);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Bypass {
        ALL,
        ONLY_SELF,
        NONE;

    }
}

