/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.store.FifoPolicy;
import net.sf.ehcache.store.LfuPolicy;
import net.sf.ehcache.store.LruPolicy;
import net.sf.ehcache.store.MemoryStoreEvictionPolicy;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;

public class MemoryStore
implements Store {
    protected static final int TOO_LARGE_TO_EFFICIENTLY_ITERATE = 5000;
    protected static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected static final int CONCURRENCY_LEVEL = 100;
    private static final Logger LOG = Logger.getLogger(MemoryStore.class.getName());
    protected Policy policy;
    protected boolean useKeySample;
    protected Ehcache cache;
    protected Map map;
    protected final Store diskStore;
    protected Status status = Status.STATUS_UNINITIALISED;
    protected int maximumSize;
    private AtomicReferenceArray<Object> keyArray;
    private AtomicInteger keySamplePointer;

    protected MemoryStore(Ehcache cache, Store diskStore) {
        this.cache = cache;
        this.maximumSize = cache.getCacheConfiguration().getMaxElementsInMemory();
        this.diskStore = diskStore;
        this.determineEvictionPolicy(cache);
        this.map = new ConcurrentHashMap(this.maximumSize, 0.75f, 100);
        if (this.maximumSize > 5000) {
            this.useKeySample = true;
            this.keyArray = new AtomicReferenceArray(this.maximumSize);
            this.keySamplePointer = new AtomicInteger(0);
        }
        this.status = Status.STATUS_ALIVE;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Initialized " + this.getClass().getName() + " for " + cache.getName());
        }
    }

    public static MemoryStore create(Ehcache cache, Store diskStore) {
        MemoryStore memoryStore = new MemoryStore(cache, diskStore);
        return memoryStore;
    }

    public final void put(Element element) throws CacheException {
        if (element != null) {
            this.map.put(element.getObjectKey(), element);
            this.doPut(element);
        }
    }

    public final Element get(Object key) {
        if (key == null) {
            return null;
        }
        Element element = (Element)this.map.get(key);
        if (element != null) {
            element.updateAccessStatistics();
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.cache.getName() + "Cache: " + this.cache.getName() + "MemoryStore hit for " + key);
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.cache.getName() + "Cache: " + this.cache.getName() + "MemoryStore miss for " + key);
        }
        return element;
    }

    public final Element getQuiet(Object key) {
        Element cacheElement = (Element)this.map.get(key);
        if (cacheElement != null) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.cache.getName() + "Cache: " + this.cache.getName() + "MemoryStore hit for " + key);
            }
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.cache.getName() + "Cache: " + this.cache.getName() + "MemoryStore miss for " + key);
        }
        return cacheElement;
    }

    public final Element remove(Object key) {
        if (key == null) {
            return null;
        }
        Element element = (Element)this.map.remove(key);
        if (element != null) {
            return element;
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, this.cache.getName() + "Cache: Cannot remove entry as key " + key + " was not found");
        }
        return null;
    }

    public final void removeAll() throws CacheException {
        this.clear();
    }

    protected final void clear() {
        this.map.clear();
        if (this.useKeySample) {
            for (int i = 0; i < this.keyArray.length(); ++i) {
                this.keyArray.set(i, null);
            }
        }
    }

    public final synchronized void dispose() {
        if (this.status.equals(Status.STATUS_SHUTDOWN)) {
            return;
        }
        this.status = Status.STATUS_SHUTDOWN;
        this.flush();
        this.cache = null;
        this.map = null;
        this.keyArray = null;
        this.keySamplePointer = null;
    }

    public final void flush() {
        if (this.cache.getCacheConfiguration().isDiskPersistent()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, this.cache.getName() + " is persistent. Spooling " + this.map.size() + " elements to the disk store.");
            }
            this.spoolAllToDisk();
        }
        if (this.cache.getCacheConfiguration().isClearOnFlush()) {
            this.clear();
        }
    }

    protected final void spoolAllToDisk() {
        boolean clearOnFlush = this.cache.getCacheConfiguration().isClearOnFlush();
        Object[] keys = this.getKeyArray();
        for (int i = 0; i < keys.length; ++i) {
            Element element = (Element)this.map.get(keys[i]);
            if (element == null) continue;
            if (!element.isSerializable()) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.log(Level.FINE, "Object with key " + element.getObjectKey() + " is not Serializable and is not being overflowed to disk.");
                continue;
            }
            this.spoolToDisk(element);
            if (!clearOnFlush) continue;
            this.remove(keys[i]);
        }
    }

    protected void spoolToDisk(Element element) {
        this.diskStore.put(element);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, this.cache.getName() + "Cache: spool to disk done for: " + element.getObjectKey());
        }
    }

    public final Status getStatus() {
        return this.status;
    }

    public final Object[] getKeyArray() {
        return this.map.keySet().toArray();
    }

    public final int getSize() {
        return this.map.size();
    }

    public final boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    public final long getSizeInBytes() throws CacheException {
        long sizeInBytes = 0L;
        for (Object o : this.map.values()) {
            Element element = (Element)o;
            if (element == null) continue;
            sizeInBytes += element.getSerializedSize();
        }
        return sizeInBytes;
    }

    protected final void evict(Element element) throws CacheException {
        boolean spooled = false;
        if (this.cache.getCacheConfiguration().isOverflowToDisk()) {
            if (!element.isSerializable()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, new StringBuffer("Object with key ").append(element.getObjectKey()).append(" is not Serializable and cannot be overflowed to disk").toString());
                }
            } else {
                this.spoolToDisk(element);
                spooled = true;
            }
        }
        if (!spooled) {
            this.cache.getCacheEventNotificationService().notifyElementEvicted(element, false);
        }
    }

    protected final void notifyExpiry(Element element) {
        this.cache.getCacheEventNotificationService().notifyElementExpiry(element, false);
    }

    protected final boolean isFull() {
        return this.map.size() > this.maximumSize;
    }

    public void expireElements() {
    }

    public boolean bufferFull() {
        return false;
    }

    Map getBackingMap() {
        return this.map;
    }

    protected void doPut(Element elementJustAdded) {
        if (this.isFull()) {
            this.removeElementChosenByEvictionPolicy(elementJustAdded);
        }
        if (this.useKeySample) {
            this.saveKey(elementJustAdded);
        }
    }

    protected void saveKey(Element elementJustAdded) {
        int index = this.incrementIndex();
        Object key = this.keyArray.get(index);
        Element oldElement = null;
        if (key != null) {
            oldElement = (Element)this.map.get(key);
        }
        if (oldElement != null) {
            if (this.policy.compare(oldElement, elementJustAdded)) {
                this.keyArray.set(index, elementJustAdded.getObjectKey());
            }
        } else {
            this.keyArray.set(index, elementJustAdded.getObjectKey());
        }
    }

    protected int incrementIndex() {
        int index = this.keySamplePointer.getAndIncrement();
        if (index > this.keyArray.length() - 1) {
            this.keySamplePointer.set(0);
            return 0;
        }
        return index;
    }

    protected void removeElementChosenByEvictionPolicy(Element elementJustAdded) {
        Element element;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Cache is full. Removing element ...");
        }
        if ((element = this.findEvictionCandidate(elementJustAdded)) == null) {
            LOG.log(Level.FINE, "Eviction selection miss. Selected element is null");
            return;
        }
        if (element.isExpired()) {
            this.remove(element.getObjectKey());
            this.notifyExpiry(element);
            return;
        }
        this.evict(element);
        this.remove(element.getObjectKey());
    }

    protected final Element findEvictionCandidate(Element elementJustAdded) {
        Element[] elements;
        Element element = null;
        if (this.useKeySample) {
            elements = this.sampleElementsViaKeyArray();
            element = this.policy.selectedBasedOnPolicy(elements, elementJustAdded);
        }
        if (element != null) {
            return element;
        }
        elements = this.sampleElements(this.map.size());
        return this.policy.selectedBasedOnPolicy(elements, elementJustAdded);
    }

    protected Element[] sampleElementsViaKeyArray() {
        int[] indices = LfuPolicy.generateRandomSampleIndices(this.maximumSize);
        Element[] elements = new Element[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            Object key = this.keyArray.get(indices[i]);
            if (key == null) continue;
            elements[i] = (Element)this.map.get(key);
        }
        return elements;
    }

    protected Element[] sampleElements(int size) {
        int[] offsets = LfuPolicy.generateRandomSample(size);
        Element[] elements = new Element[offsets.length];
        Iterator iterator = this.map.values().iterator();
        for (int i = 0; i < offsets.length; ++i) {
            for (int j = 0; j < offsets[i]; ++j) {
                try {
                    iterator.next();
                    continue;
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
            }
            try {
                elements[i] = (Element)iterator.next();
                continue;
            }
            catch (NoSuchElementException e) {
                // empty catch block
            }
        }
        return elements;
    }

    protected void determineEvictionPolicy(Ehcache cache) {
        MemoryStoreEvictionPolicy policySelection = cache.getCacheConfiguration().getMemoryStoreEvictionPolicy();
        if (policySelection.equals(MemoryStoreEvictionPolicy.LRU)) {
            this.policy = new LruPolicy();
        } else if (policySelection.equals(MemoryStoreEvictionPolicy.FIFO)) {
            this.policy = new FifoPolicy();
        } else if (policySelection.equals(MemoryStoreEvictionPolicy.LFU)) {
            this.policy = new LfuPolicy();
        }
    }

    public Policy getEvictionPolicy() {
        return this.policy;
    }

    public void setEvictionPolicy(Policy policy) {
        this.policy = policy;
    }
}

