/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.transaction;

import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.commands.WriteCommand;
import org.jboss.cache.commands.tx.PrepareCommand;
import org.jboss.cache.marshall.Marshaller;
import org.jboss.cache.transaction.GlobalTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionLog {
    private final Map<GlobalTransaction, PrepareCommand> pendingPrepares = new ConcurrentHashMap<GlobalTransaction, PrepareCommand>();
    private final BlockingQueue<LogEntry> entries = new LinkedBlockingQueue<LogEntry>();
    private AtomicBoolean active = new AtomicBoolean();
    private static Log log = LogFactory.getLog(TransactionLog.class);

    public void logPrepare(PrepareCommand command) {
        this.pendingPrepares.put(command.getGlobalTransaction(), command);
    }

    public void logCommit(GlobalTransaction gtx) {
        PrepareCommand command = this.pendingPrepares.remove(gtx);
        if (command != null && this.isActive()) {
            this.addEntry(gtx, command.getModifications());
        }
    }

    private void addEntry(GlobalTransaction gtx, WriteCommand command) {
        this.addEntry(gtx, Collections.singletonList(command));
    }

    private void addEntry(GlobalTransaction gtx, List<WriteCommand> commands) {
        LogEntry entry = new LogEntry(gtx, commands);
        while (true) {
            try {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Added commit entry to tx log" + entry));
                }
                this.entries.put(entry);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public void logOnePhaseCommit(GlobalTransaction gtx, List<WriteCommand> modifications) {
        if (gtx != null) {
            this.pendingPrepares.remove(gtx);
        }
        if (this.isActive() && !modifications.isEmpty()) {
            this.addEntry(gtx, modifications);
        }
    }

    public void logNoTxWrite(WriteCommand write) {
        if (this.isActive()) {
            this.addEntry(null, write);
        }
    }

    public void rollback(GlobalTransaction gtx) {
        this.pendingPrepares.remove(gtx);
    }

    public final boolean isActive() {
        return this.active.get();
    }

    public boolean activate() {
        return this.active.compareAndSet(false, true);
    }

    public void deactivate() {
        this.active.set(false);
        if (this.entries.size() > 0) {
            log.error((Object)("Unprocessed Transaction Log Entries! = " + this.entries.size()));
        }
        this.entries.clear();
    }

    public int size() {
        return this.entries.size();
    }

    public void writeCommitLog(Marshaller marshaller, ObjectOutputStream out) throws Exception {
        ArrayList buffer = new ArrayList(10);
        while (this.entries.drainTo(buffer, 10) > 0) {
            for (LogEntry entry : buffer) {
                marshaller.objectToObjectStream(entry, out);
            }
            buffer.clear();
        }
    }

    public void writePendingPrepares(Marshaller marshaller, ObjectOutputStream out) throws Exception {
        for (PrepareCommand entry : this.pendingPrepares.values()) {
            marshaller.objectToObjectStream(entry, out);
        }
    }

    public final boolean hasPendingPrepare(PrepareCommand command) {
        return this.pendingPrepares.containsKey(command.getGlobalTransaction());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LogEntry {
        private final GlobalTransaction transaction;
        private final List<WriteCommand> modifications;

        public LogEntry(GlobalTransaction transaction, List<WriteCommand> modifications) {
            this.transaction = transaction;
            this.modifications = modifications;
        }

        public GlobalTransaction getTransaction() {
            return this.transaction;
        }

        public List<WriteCommand> getModifications() {
            return this.modifications;
        }
    }
}

