/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import java.security.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gatein.common.net.media.MediaType;
import org.gatein.common.util.MarkupInfo;
import org.gatein.common.util.ParameterValidation;
import org.gatein.pc.api.Mode;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.StateString;
import org.gatein.pc.api.WindowState;
import org.gatein.pc.api.invocation.PortletInvocation;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.spi.PortalContext;
import org.gatein.pc.api.spi.SecurityContext;
import org.gatein.pc.api.spi.UserContext;
import org.gatein.pc.api.spi.WindowContext;
import org.gatein.pc.api.state.AccessMode;
import org.gatein.registration.Registration;
import org.gatein.wsrp.UserContextConverter;
import org.gatein.wsrp.WSRPExceptionFactory;
import org.gatein.wsrp.WSRPUtils;
import org.gatein.wsrp.producer.MarkupHandler;
import org.gatein.wsrp.producer.MarkupRequest;
import org.gatein.wsrp.producer.WSRPInstanceContext;
import org.gatein.wsrp.producer.WSRPPortletInvocationContext;
import org.gatein.wsrp.producer.WSRPProducerImpl;
import org.oasis.wsrp.v1.InvalidHandle;
import org.oasis.wsrp.v1.InvalidRegistration;
import org.oasis.wsrp.v1.MarkupParams;
import org.oasis.wsrp.v1.MarkupType;
import org.oasis.wsrp.v1.MissingParameters;
import org.oasis.wsrp.v1.OperationFailed;
import org.oasis.wsrp.v1.PortletContext;
import org.oasis.wsrp.v1.PortletDescription;
import org.oasis.wsrp.v1.RegistrationContext;
import org.oasis.wsrp.v1.RuntimeContext;
import org.oasis.wsrp.v1.UnsupportedMimeType;
import org.oasis.wsrp.v1.UnsupportedMode;
import org.oasis.wsrp.v1.UnsupportedWindowState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RequestProcessor {
    private static final String WINDOW_STATE = "window state";
    private static final String PORTLET_MODE = "portlet mode";
    protected PortletInvocation invocation;
    protected MarkupRequest markupRequest;
    protected PortletDescription portletDescription;
    protected Portlet portlet;
    protected WSRPInstanceContext instanceContext;
    protected WSRPProducerImpl producer;

    protected RequestProcessor(WSRPProducerImpl producer) {
        this.producer = producer;
    }

    void prepareInvocation() throws InvalidRegistration, OperationFailed, InvalidHandle, UnsupportedMimeType, UnsupportedWindowState, UnsupportedMode, MissingParameters {
        Registration registration = this.producer.getRegistrationOrFailIfInvalid(this.getRegistrationContext());
        RuntimeContext runtimeContext = this.getRuntimeContext();
        WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)runtimeContext, (String)"RuntimeContext", (String)this.getContextName());
        this.checkForSessionIDs(runtimeContext);
        MarkupParams params = this.getMarkupParams();
        WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)params, (String)"MarkupParams", (String)this.getContextName());
        PortletContext wsrpPC = this.getPortletContext();
        WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)wsrpPC, (String)"PortletContext", (String)this.getContextName());
        org.gatein.pc.api.PortletContext portletContext = WSRPUtils.convertToPortalPortletContext((PortletContext)wsrpPC);
        try {
            this.portlet = this.producer.getPortletWith(portletContext, registration);
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)("Could not retrieve portlet '" + portletContext + "'"), (Throwable)e);
        }
        List desiredLocales = params.getLocales();
        this.portletDescription = this.producer.getPortletDescription(this.portlet, desiredLocales);
        if (Boolean.TRUE.equals(this.portletDescription.isUsesMethodGet())) {
            throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)"Portlets using GET method in forms are not currently supported.", null);
        }
        List markupTypes = this.portletDescription.getMarkupTypes();
        this.markupRequest = this.createMarkupRequestFrom(markupTypes, params, this.portlet);
        StateString navigationalState = this.createNavigationalState(params.getNavigationalState());
        org.oasis.wsrp.v1.UserContext wsrpUserContext = this.getUserContext();
        this.checkUserContext(wsrpUserContext);
        SecurityContext securityContext = this.createSecurityContext(params, runtimeContext, wsrpUserContext);
        MarkupInfo streamInfo = this.createStreamInfo(this.markupRequest);
        PortalContext portalContext = this.createPortalContext(params, this.markupRequest);
        UserContext userContext = this.createUserContext(wsrpUserContext, this.markupRequest.getLocale(), desiredLocales);
        this.instanceContext = this.createInstanceContext(portletContext, this.getAccessMode(), runtimeContext.getPortletInstanceKey());
        WindowContext windowContext = this.createWindowContext(portletContext.getId(), runtimeContext);
        WSRPPortletInvocationContext context = new WSRPPortletInvocationContext(streamInfo, securityContext, portalContext, userContext, this.instanceContext, windowContext);
        PortletInvocation invocation = this.initInvocation(context);
        invocation.setTarget(this.portlet.getContext());
        invocation.setWindowState(WSRPUtils.getJSR168WindowStateFromWSRPName((String)this.markupRequest.getWindowState()));
        invocation.setMode(WSRPUtils.getJSR168PortletModeFromWSRPName((String)this.markupRequest.getMode()));
        invocation.setNavigationalState(navigationalState);
        context.contextualize(invocation);
        this.setInvocation(invocation);
    }

    abstract RegistrationContext getRegistrationContext();

    abstract RuntimeContext getRuntimeContext();

    abstract MarkupParams getMarkupParams();

    abstract PortletContext getPortletContext();

    abstract org.oasis.wsrp.v1.UserContext getUserContext();

    abstract String getContextName();

    abstract AccessMode getAccessMode() throws MissingParameters;

    abstract PortletInvocation initInvocation(WSRPPortletInvocationContext var1);

    abstract Object processResponse(PortletInvocationResponse var1);

    private MarkupRequest createMarkupRequestFrom(List<MarkupType> markupTypes, MarkupParams params, Portlet portlet) throws UnsupportedMimeType, UnsupportedMode, UnsupportedWindowState {
        String windowState;
        String mode;
        List desiredMIMETypes = params.getMimeTypes();
        MarkupType markupType = null;
        block4: for (String desiredMIMEType : desiredMIMETypes) {
            for (MarkupType type : markupTypes) {
                if (!desiredMIMEType.equals(type.getMimeType())) continue;
                markupType = type;
                continue block4;
            }
        }
        if (markupType == null) {
            throw (UnsupportedMimeType)WSRPExceptionFactory.throwWSException((String)"UnsupportedMimeType", (String)("None of the specified MIME types are supported by portlet '" + portlet.getContext().getId() + "'"), null);
        }
        List locales = params.getLocales();
        List supportedLocales = markupType.getLocales();
        if (supportedLocales != null) {
            markupType.getLocales().clear();
            boolean found = false;
            for (String locale : locales) {
                for (String supportedLocale : supportedLocales) {
                    if (!locale.equals(supportedLocale)) continue;
                    markupType.getLocales().add(locale);
                    found = true;
                    break;
                }
                if (!found) continue;
                break;
            }
            if (!found) {
                markupType.getLocales().addAll(locales);
            }
        } else {
            markupType.getLocales().addAll(locales);
        }
        try {
            mode = this.getMatchingOrFailFrom(markupType.getModes(), params.getMode(), PORTLET_MODE);
        }
        catch (IllegalArgumentException e) {
            throw (UnsupportedMode)WSRPExceptionFactory.throwWSException((String)"UnsupportedMode", (String)("Unsupported mode '" + params.getMode() + "'"), (Throwable)e);
        }
        try {
            windowState = this.getMatchingOrFailFrom(markupType.getWindowStates(), params.getWindowState(), WINDOW_STATE);
        }
        catch (IllegalArgumentException e) {
            throw (UnsupportedWindowState)WSRPExceptionFactory.throwWSException((String)"UnsupportedWindowState", (String)("Unsupported window state '" + params.getMode() + "'"), (Throwable)e);
        }
        String characterSet = this.getMatchingOrDefaultFrom(Collections.<String>emptyList(), params.getMarkupCharacterSets(), "UTF-8");
        return new MarkupRequest(markupType, mode, windowState, characterSet, portlet);
    }

    private String getMatchingOrFailFrom(List<String> possibleValues, String desired, String valueType) throws IllegalArgumentException {
        if (possibleValues.contains(desired)) {
            return desired;
        }
        throw new IllegalArgumentException(desired + " is not a supported " + valueType);
    }

    private String getMatchingOrDefaultFrom(List<String> possibleValues, List<String> preferredValues, String defaultValue) {
        if (preferredValues != null && possibleValues != null) {
            for (String preferredValue : preferredValues) {
                if (!possibleValues.contains(preferredValue)) continue;
                return preferredValue;
            }
        }
        return defaultValue;
    }

    private void checkUserContext(org.oasis.wsrp.v1.UserContext wsrpUserContext) throws MissingParameters {
        if (wsrpUserContext != null) {
            WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)wsrpUserContext.getUserContextKey(), (String)"User Context Key", (String)"UserContext");
        }
    }

    private void checkForSessionIDs(RuntimeContext runtimeContext) throws OperationFailed {
        if (runtimeContext.getSessionID() != null) {
            MarkupHandler.throwOperationFaultOnSessionOperation();
        }
    }

    protected StateString createNavigationalState(String navigationalState) {
        if (navigationalState == null) {
            return null;
        }
        return StateString.create((String)navigationalState);
    }

    private WSRPInstanceContext createInstanceContext(org.gatein.pc.api.PortletContext portletContext, AccessMode accessMode, String instanceId) {
        return new WSRPInstanceContext(portletContext, accessMode, instanceId);
    }

    private WindowContext createWindowContext(final String portletHandle, final RuntimeContext runtimeContext) {
        return new WindowContext(){

            public String getId() {
                String prefix = runtimeContext.getNamespacePrefix();
                if (prefix != null && prefix.length() > 0) {
                    return prefix;
                }
                return portletHandle;
            }
        };
    }

    private UserContext createUserContext(org.oasis.wsrp.v1.UserContext userContext, String preferredLocale, List<String> supportedLocales) {
        return UserContextConverter.createPortalUserContextFrom((org.oasis.wsrp.v1.UserContext)userContext, supportedLocales, (String)preferredLocale);
    }

    private PortalContext createPortalContext(final MarkupParams params, final MarkupRequest markupRequest) {
        return new PortalContext(){

            public String getInfo() {
                return PortalContext.VERSION.toString();
            }

            public Set<WindowState> getWindowStates() {
                List validNewWindowStates = params.getValidNewWindowStates();
                if (ParameterValidation.existsAndIsNotEmpty((Collection)validNewWindowStates)) {
                    HashSet<WindowState> states = new HashSet<WindowState>(validNewWindowStates.size());
                    for (String state : validNewWindowStates) {
                        states.add(WSRPUtils.getJSR168WindowStateFromWSRPName((String)state));
                    }
                    return states;
                }
                return markupRequest.getSupportedWindowStates();
            }

            public Set<Mode> getModes() {
                List validNewModes = params.getValidNewModes();
                if (ParameterValidation.existsAndIsNotEmpty((Collection)validNewModes)) {
                    HashSet<Mode> modes = new HashSet<Mode>(validNewModes.size());
                    for (String mode : validNewModes) {
                        modes.add(WSRPUtils.getJSR168PortletModeFromWSRPName((String)mode));
                    }
                    return modes;
                }
                return markupRequest.getSupportedModes();
            }

            public Map<String, String> getProperties() {
                return Collections.emptyMap();
            }
        };
    }

    private MarkupInfo createStreamInfo(MarkupRequest markupRequest) throws UnsupportedMimeType {
        MarkupInfo markupInfo;
        try {
            markupInfo = new MarkupInfo(MediaType.create((String)markupRequest.getMediaType()), markupRequest.getCharacterSet());
        }
        catch (IllegalArgumentException e) {
            throw (UnsupportedMimeType)WSRPExceptionFactory.throwWSException((String)"UnsupportedMimeType", (String)e.getLocalizedMessage(), (Throwable)e);
        }
        return markupInfo;
    }

    private SecurityContext createSecurityContext(final MarkupParams params, final RuntimeContext runtimeContext, final org.oasis.wsrp.v1.UserContext wsrpUserContext) {
        return new SecurityContext(){

            public boolean isSecure() {
                return params.isSecureClientCommunication();
            }

            public String getAuthType() {
                return runtimeContext.getUserAuthentication();
            }

            public String getRemoteUser() {
                if (wsrpUserContext != null) {
                    return wsrpUserContext.getUserContextKey();
                }
                return null;
            }

            public Principal getUserPrincipal() {
                return null;
            }

            public boolean isUserInRole(String roleName) {
                return wsrpUserContext != null && wsrpUserContext.getUserCategories().contains(roleName);
            }

            public boolean isAuthenticated() {
                return wsrpUserContext != null;
            }
        };
    }

    public PortletInvocation getInvocation() {
        return this.invocation;
    }

    public void setInvocation(PortletInvocation invocation) {
        this.invocation = invocation;
    }
}

