/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorLog {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.ErrorLog");
    public static final String REMOVE = "rem";
    public static final String ADD = "add";
    private final File logFile;
    private FileChannel out;
    private int fileSize = 0;

    public ErrorLog(File file, int errorLogSize) throws IOException {
        this.fileSize = errorLogSize;
        this.logFile = file;
        this.openFile(file);
    }

    private void openFile(File log) throws IOException {
        if (!log.exists()) {
            log.getParentFile().mkdirs();
            log.createNewFile();
            this.out = new FileOutputStream(log).getChannel();
            this.out.position(1024 * this.fileSize - 1);
            this.out.write(ByteBuffer.wrap(new byte[]{0}));
            this.out.position(0L);
            this.out.force(false);
        } else {
            this.out = new FileOutputStream(log, true).getChannel();
        }
    }

    public void append(String action, String uuid) throws IOException {
        this.initOut();
        this.out.write(ByteBuffer.wrap((action + " " + uuid + "\n").getBytes()));
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.force(false);
        }
    }

    public void clear() throws IOException {
        if (this.out != null) {
            this.out.truncate(0L);
            this.out.close();
            this.out = new FileOutputStream(this.logFile).getChannel();
            this.out.position(1024 * this.fileSize - 1);
            this.out.write(ByteBuffer.wrap(new byte[]{0}));
            this.out.position(0L);
            this.out.force(false);
        }
    }

    private void initOut() throws IOException {
        if (this.out == null) {
            FileOutputStream os = new FileOutputStream(this.logFile, false);
            this.out = os.getChannel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> readList() throws IOException {
        ArrayList<String> arrayList;
        block6: {
            FileInputStream in = new FileInputStream(this.logFile);
            try {
                String line;
                ArrayList<String> list = new ArrayList<String>();
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                while ((line = reader.readLine()) != null) {
                    if (line.matches("\\x00++")) continue;
                    list.add(line);
                }
                arrayList = list;
                Object var7_6 = null;
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var7_7 = null;
                    if (in == null) break block7;
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)("Exception while closing error log: " + e.toString()));
                    }
                }
                throw throwable;
            }
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Exception while closing error log: " + e.toString()));
            }
        }
        return arrayList;
    }

    public void readChanges(Set<String> rem, Set<String> add) throws IOException {
        List<String> list = this.readList();
        Iterator<String> it = list.iterator();
        while (it.hasNext()) {
            String[] str = it.next().split(" ");
            if (str.length != 2) continue;
            if (str[0].equals(ADD)) {
                add.add(str[1]);
                continue;
            }
            if (!str[0].equals(REMOVE)) continue;
            rem.add(str[1]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChanges(Set<String> removed, Set<String> added) throws IOException {
        try {
            if (!removed.isEmpty()) {
                Iterator<String> rem = removed.iterator();
                while (rem.hasNext()) {
                    this.append(REMOVE, rem.next());
                }
            }
            if (!added.isEmpty()) {
                Iterator<String> add = added.iterator();
                while (add.hasNext()) {
                    this.append(ADD, add.next());
                }
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.flush();
            throw throwable;
        }
        this.flush();
    }

    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                this.out = null;
            }
        }
    }
}

