/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.frameworks.jcr.command.web.fckeditor;

import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.exoplatform.frameworks.jcr.command.web.GenericWebAppContext;
import org.exoplatform.frameworks.jcr.command.web.fckeditor.FCKConnectorXMLOutput;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class GetFoldersOrFilesCommand
extends FCKConnectorXMLOutput
implements Command {
    public boolean execute(Context context) throws Exception {
        Node n;
        NodeIterator nodeList;
        Element nodesElement;
        String workspace;
        GenericWebAppContext webCtx = (GenericWebAppContext)context;
        HttpServletResponse response = webCtx.getResponse();
        HttpServletRequest request = webCtx.getRequest();
        String filter = (String)context.get((Object)"Command");
        String type = (String)context.get((Object)"Type");
        if (type == null) {
            type = "";
        }
        if ((workspace = (String)webCtx.get("org.exoplatform.frameworks.jcr.command.web.fckeditor.digitalAssetsWorkspace")) == null) {
            workspace = "digital-assets";
        }
        String currentFolderStr = this.getCurrentFolderPath(webCtx);
        webCtx.setCurrentWorkspace(workspace);
        Node currentFolder = (Node)webCtx.getSession().getItem(currentFolderStr);
        String repoName = ((ManageableRepository)webCtx.getSession().getRepository()).getConfiguration().getName();
        String url = request.getContextPath() + this.makeRESTPath(repoName, workspace, currentFolderStr);
        this.initRootElement(filter, type, currentFolderStr, url);
        Document doc = this.rootElement.getOwnerDocument();
        if (!filter.equals("GetFiles")) {
            nodesElement = this.rootElement.getOwnerDocument().createElement("Folders");
            this.rootElement.appendChild(nodesElement);
            nodeList = currentFolder.getNodes();
            while (nodeList.hasNext()) {
                n = nodeList.nextNode();
                if (!n.isNodeType("nt:folder") && !n.isNodeType("nt:unstructured")) continue;
                Element folderElement = doc.createElement("Folder");
                folderElement.setAttribute("name", n.getName());
                nodesElement.appendChild(folderElement);
            }
        }
        if (!filter.equals("GetFolders")) {
            nodesElement = this.rootElement.getOwnerDocument().createElement("Files");
            this.rootElement.appendChild(nodesElement);
            nodeList = currentFolder.getNodes();
            while (nodeList.hasNext()) {
                n = nodeList.nextNode();
                if (!n.isNodeType("nt:file")) continue;
                Element fileElement = doc.createElement("File");
                long size = n.getNode("jcr:content").getProperty("jcr:data").getLength();
                fileElement.setAttribute("name", n.getName());
                fileElement.setAttribute("size", "" + size);
                nodesElement.appendChild(fileElement);
            }
        }
        this.outRootElement(response);
        return false;
    }
}

