/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachDetachException
extends RuntimeException {
    static final Command attachCommand = new Command(){

        public void execute(Widget w) {
            w.onAttach();
        }
    };
    static final Command detachCommand = new Command(){

        public void execute(Widget w) {
            w.onDetach();
        }
    };
    private Set<Throwable> causes;

    public static void tryCommand(Iterable<Widget> hasWidgets, Command c) {
        HashSet<Throwable> caught = null;
        for (Widget w : hasWidgets) {
            try {
                c.execute(w);
            }
            catch (Throwable e) {
                if (caught == null) {
                    caught = new HashSet<Throwable>();
                }
                caught.add(e);
            }
        }
        if (caught != null) {
            throw new AttachDetachException(caught);
        }
    }

    public AttachDetachException(Set<Throwable> causes) {
        super("One or more exceptions caught, see full set in AttachDetachException#getCauses", causes.size() == 0 ? null : causes.toArray(new Throwable[0])[0]);
        this.causes = causes;
    }

    public Set<Throwable> getCauses() {
        return this.causes;
    }

    public static interface Command {
        public void execute(Widget var1);
    }
}

